<?php

namespace App\Http\Livewire\Development\Styles;

use App\Models\Gauge;
use App\Models\Design;
use App\Models\Styles;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Suppliers;
use App\Models\Colourways;
use App\Models\Departments;
use Livewire\Attributes\On;
use App\Models\StyleVersions;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;

class QuickAdd extends Component
{
    use WithFileUploads;


    #[Validate([
        'rows.*.new_design' => ['required_if:rows.*,isNotEmpty', 'boolean'],
        'rows.*.rt_code' => ['nullable', 'exists:designs,id'],
        'rows.*.department' => ['required_if:rows.*,isNotEmpty', 'exists:departments,id'],
        'rows.*.season' => ['required_if:rows.*,isNotEmpty', 'exists:seasons,id'],
        'rows.*.customer' => ['required_if:rows.*,isNotEmpty', 'exists:customers,id'],
        'rows.*.category' => ['required_if:rows.*,isNotEmpty', 'in:ladies,mens,childrens,accessories'],
        'rows.*.customer_ref' => ['nullable', 'string', 'max:35'],
        'rows.*.description' => ['required_if:rows.*,isNotEmpty', 'string', 'max:35'],
        'rows.*.gauge' => ['required_if:rows.*,isNotEmpty', 'exists:gauges,id'],
        'rows.*.carryover' => ['nullable', 'boolean'],
        'rows.*.factory' => ['required_if:rows.*,isNotEmpty', 'exists:suppliers,id'],
        'rows.*.colourway_names' => ['required_if:rows.*,isNotEmpty', 'string', 'max:200'],
    ])]
    public $rows = [[]], $rtPicker = -1, $designs_search; // Initialize with one empty row

    #[Computed]
    public function departments()
    {
        return Departments::allCached(); // Fetch departments from your database
    }

    #[Computed]
    public function seasons()
    {
        return Seasons::allCached(); // Fetch seasons from your database
    }

    #[Computed]
    public function factories()
    {
        return Suppliers::get(); // Fetch seasons from your database
    }

    #[Computed]
    public function customers()
    {
        return Customer::allCached(); // Fetch seasons from your database
    }

    #[Computed]
    public function gauges()
    {
        return Gauge::allCached(); // Fetch seasons from your database
    }

    public function designs(){
		return Design::search($this->designs_search)->limit(10)->get();
	}
    public function addRow()
    {
        $this->rows[] = ['rt_code' => -1]; // Add a new empty row
    }

    public function newRtCode($rowIndex)
    {
        $this->rows[$rowIndex]['new_design'] = TRUE;
    }

    public function removeRow($index)
    {
        unset($this->rows[$index]);
        $this->rows = array_values($this->rows); // Re-index the array
    }

    public function saveData()
    {
        $this->validate();

        foreach ($this->rows as $row) {
            if(!empty($row)){
                $design = Design::firstOrCreate([
                    'id' => $row['rt_code'] ?? 0,
                ],[
                    'description' => $row['description'],
                    'customers_id' => $row['customer'],
                    'factory_id' => $row['factory'],
                    'gauge_id' => $row['gauge'],
                    'yarn' => "",
                ]);

                $style = Styles::firstOrCreate([
                    'designs_id' => $design->id,
                    'departments_id' => $row['department'],
                    'seasons_id' => $row['season'],
                    'customers_id' => $row['customer'],
                ],[
                    'category' => $row['category'],
                    'customer_ref' => $row['customer_ref'],
                ]);

                $styleVersion = StyleVersions::firstOrCreate([
                    'styles_id' => $style->id,
                    'factory_id' => $row['factory'],
                ],[
                    'name' => "A",
                    'gauge_id' => $row['gauge'],
                ]);

                foreach(str_getcsv($row['colourway_names']) as $c=>$colourway){
                    Colourways::firstOrCreate([
                        'style_versions_id' => $styleVersion->id,
                        'name' => $colourway
                    ],[
                        'colour_type' => 'solid',
                    ]);
                }
            }
        }

        $this->resetForm();
        session()->flash('message', 'Data saved successfully!');
    }

    public function openRTPicker($index){
        $this->rtPicker = $index;
        // dd($this->commodityPicker);
    }

    public function closeRTPicker(){
        $this->rtPicker = -1;
    }

    public function setRTCode($code){
        $design = Design::find($code);
		$this->rows[$this->rtPicker]['rt_code'] = $code;
        $this->rows[$this->rtPicker]['customer'] = $design->customers_id;
        $this->rows[$this->rtPicker]['factory'] = $design->factory_id;
        $this->rows[$this->rtPicker]['gauge'] = $design->gauge_id;
        $this->rows[$this->rtPicker]['description'] = $design->description;
		$this->closeRTPicker();
	}

    #[On('close-modal')]
    public function resetForm(){
        $this->reset();
    }

    public function render()
    {
        if(!empty(end($this->rows))){
            $this->rows[] = [];
        }
        return view('livewire.development.styles.quick-add'); // Replace with your actual view path
    }
}
