<?php

namespace App\Http\Livewire\Development\Styles;

use App\Models\Styles;
use App\Models\Seasons;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Departments;
use Livewire\Attributes\On;
use Livewire\Attributes\Computed;
use Illuminate\Validation\ValidationException;

class CloneColourways extends Component
{

    public $style = NULL, $styleSearch, $colourwayPicker;

    public $clone = [];


    #[Computed()]
	public function departments(){
		return Departments::where('hidden', false)->get();
	}
	#[Computed()]
	public function seasons(){
		return Seasons::where('locked', FALSE)->get();
	}
	#[Computed()]
	public function customers(){
		return Customer::allCached();
	}
    #[Computed()]
	public function styles(){
        if(strlen(trim($this->styleSearch)) > 2){
            $query = Styles::select('id', 'designs_id', 'seasons_id', 'customer_ref')
                ->where('seasons_id', $this->clone['seasons_id'])
                ->whereRelation('seasons', 'locked', '=', 0)
                ->where(function ($query) {
                    $query->where('customer_ref', 'like', '%'.$this->styleSearch.'%')
                    ->orWhere('designs_id', 'like', '%'.$this->styleSearch.'%');
                })
                ;
            return $query->get();
        }
	}

    public function setStyleTo($style){
        $this->clone['style'] = Styles::with('style_versions')->find($style);
        $this->colourwayPicker = FALSE;
    }

    public function mount(){
        $this->style = NULL;
    }

    public function render()
    {
        return view('livewire.development.styles.clone-colourways');
    }

    #[On('clone-colourways')]
    public function open($style){
        $this->style = Styles::with('style_versions.colourways')->find($style);
        $this->clone = [
            'departments_id' => $this->style->departments_id,
            'seasons_id' => "",
            'customers_id' => $this->style->customers_id,
        ];
    }

    public function save(){
        //strip tags
        $validated = $this->validate([
            'clone.version_from' => 'required|numeric|min:0',
            'clone.version_to' => 'required|numeric|min:0',
            'clone.seasons_id' => 'required|numeric|min:0',
            'clone.style' => 'required',
        ]);

        foreach($this->style->style_versions->where('id', $this->clone['version_from'])->first()->colourways as $colourway){
            $colourway->style_versions_id = $this->clone['version_to'];
            $colourway->image = NULL;
            $colourway->img_thumb = NULL;

            $colourway->duplicate();
        }
        session()->flash('message', 'Colourways Cloned');
        session()->flash('alert-class', 'alert-success');
    }

    #[On('close-modal')]
    public function close(){
        $this->reset(['style', 'clone']);
    }
}
