<?php

namespace App\Http\Livewire\Development\Samples;

use App\Models\Sizes;
use App\Models\Samples;
use Livewire\Component;
use App\Models\SampleTypes;
use Livewire\Attributes\On;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\SamplesEditBulkForm;

class SamplesEdit extends Component
{
	public $statusID;
	public $samplesList = [];

	public SamplesEditBulkForm $form;

	#[Computed]
	public function sampleTypes(){
		return SampleTypes::allCached();
	}
	#[Computed]
	public function sizes(){
		return Sizes::allCached();
	}

	public function updated($property, $value){
		// Handle form property updates - auto-enable the update checkbox when a value field changes
		if (str_starts_with($property, 'form.') && !str_contains($property, '_update')) {
			$parts = explode('.', $property);
			$field = end($parts); // Get the field name (e.g., 'po' from 'form.po')
			$updateFlag = $field . '_update';
			$this->form->{$updateFlag} = TRUE;
		}
	}

	#[On('samples-edit')]
	public function setup($samples = NULL, $statusID = NULL){
		Gate::authorize('style:read');
		$this->statusID = $statusID;
		if($samples == NULL){

		}
		elseif(is_int($samples)){
			$this->samplesList[] = $samples;
			$this->form->set($samples);
		}
		else{
			$this->samplesList = array_keys(array_filter($samples));
		}
	}

    public function save(){
		Gate::authorize('style:update');

		$sample = $this->form->save($this->samplesList);

        if($sample != "locked"){
            $this->reset('samplesList');
            $this->dispatch('refersh-sample-status.' . $this->statusID, $sample);
            $this->dispatch('refreshData');
            $this->dispatch('close-modal');
        }
	}
}
