<?php

namespace App\Http\Livewire\Designs;

use App\Http\Livewire\BaseComponent;
use App\Models\Gauge;
use App\Models\Design;
use Livewire\Component;
use App\Models\Customer;
use App\Models\Suppliers;
use Livewire\Attributes\On;
use Livewire\Attributes\Computed;
use App\Livewire\Forms\DesignEditForm;
use Illuminate\Support\Facades\Gate;

class DesignEdit extends BaseComponent
{
	public DesignEditForm $form;

	public function mount(){
		$this->form->clear();
	}

    #[On('edit-design')]
    public function loadDesign($id)
    {
        $design = Design::find($id);

        if (!$design) {
            $this->dispatch('flash-error', ['Design not found.', 'danger']);
            $this->dispatch('close-modal');
            return; // Exit the method if the design doesn't exist
        }

        $this->form->set($design);
    }

	#[Computed]
	public function customers(){
		return Customer::allCached();
	}
	#[Computed]
	public function factories(){
		return Suppliers::allCached();
	}
	#[Computed]
	public function gauges(){
		return Gauge::allCached();
	}

	#[On('close-modal')]
	public function clearForm(){
		$this->form->clear();
	}

    public function render()
    {
		Gate::authorize('design:read');
        return view('livewire.designs.design-edit');
    }

	public function save()
    {
		Gate::authorize('design:update');
        $this->form->update();
		$this->dispatch('close-modal');
		$this->dispatch('refresh');
		$this->form->clear();
     }
}
