<?php

namespace App\Http\Livewire\Commission;

use App\Models\Samples;
use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Gate;

class SampleStatus extends Component
{
    public $statusID;
    public $sample;
    public $colourwayId;
    public $type;
    public $typeName;
    public $sampleRequired = false;

    public $sampleId;

    #[On('refresh-sample-status.{statusID}')]
    public function refresh($sample)
    {
        $this->sample = (object) $sample;
        $this->sampleId = $this->sample?->id ?? 0;
    }

    #[On('sample-saved')]
    public function reloadFromDatabase()
    {
        // Reload the latest non-deleted sample for this colourway and type from the database
        $typeIds = $this->type == 1 ? [1, 8] : ($this->type == 6 ? [6, 8] : [$this->type]);
        
        $latestSample = Samples::where('colourways_id', $this->colourwayId)
            ->whereIn('sample_types_id', $typeIds)
            ->whereNull('deleted_at')
            ->orderBy('created_at', 'desc')
            ->first();
        
        if ($latestSample) {
            $this->sample = (object) [
                'id' => $latestSample->id,
                'status' => $latestSample->status,
                'approved_date' => $latestSample->approved_date?->format('Y-m-d'),
                'date_sent' => $latestSample->date_sent?->format('Y-m-d'),
                'date_expected' => $latestSample->date_expected?->format('Y-m-d'),
            ];
            $this->sampleId = $latestSample->id;
        } else {
            $this->sample = null;
            $this->sampleId = 0;
        }
    }

    public function mount($sample, $colourwayId, $type, $typeName = '', $sampleRequired = false)
    {
        // Handle null, empty string, or empty array
        if (empty($sample)) {
            $this->sample = null;
        } elseif (is_string($sample)) {
            $decoded = json_decode($sample);
            // Check if the decoded object has an id (valid sample)
            $this->sample = (!empty($decoded) && isset($decoded->id) && $decoded->id) ? $decoded : null;
        } elseif (is_array($sample)) {
            $this->sample = !empty($sample['id']) ? (object) $sample : null;
        } else {
            $this->sample = $sample;
        }
        
        $this->sampleId = $this->sample?->id ?? 0;
        $this->colourwayId = $colourwayId;
        $this->type = $type;
        $this->typeName = $typeName;
        $this->sampleRequired = (bool) $sampleRequired;
    }

    public function addSample()
    {
        if (!Gate::check('style:update')) {
            return;
        }

        $sample = new Samples;
        $sample->colourways_id = $this->colourwayId;
        $sample->sample_types_id = $this->type;
        $sample->status = 'pending';
        $sample->save();

        $this->sample = (object) [
            'id' => $sample->id,
            'status' => 'pending',
            'approved_date' => null,
            'date_sent' => null,
            'date_expected' => null,
        ];
        $this->sampleId = $sample->id;

        $this->dispatch('sample-saved');
    }

    public function editSample()
    {
        if ($this->sampleId) {
            $this->dispatch('open-sample-edit', sampleId: $this->sampleId);
        }
    }

    public function render()
    {
        return view('livewire.commission.sample-status');
    }
}

