<?php

namespace App\Http\Livewire\Commission;

use Livewire\Component;

class Placeholder extends Component
{
    public string $title;
    public string $icon;
    public string $description;

    public function mount(string $title = 'Coming Soon', string $icon = 'fas fa-hard-hat', string $description = 'This feature is under development.')
    {
        $this->title = $title;
        $this->icon = $icon;
        $this->description = $description;
    }

    public function render()
    {
        return view('livewire.commission.placeholder')->layout('layouts.commission');
    }
}





