<?php

namespace App\Http\Livewire;

use App\Models\User;
use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\Attributes\Locked;
use Livewire\Attributes\Validate;

class ColumnSelector extends BaseComponent
{
    #[Validate(['columns.*' => ['nullable', 'boolean']])]
    public $columns;

    #[Locked]
    public float $columnsVersion;

    #[Locked]
    public string $filterKey;

    #[Locked]
    public string $variant = 'legacy';

    protected $listeners = ['refresh-columns' => 'refreshColumns']; // Listen for the refresh event

    public function mount($columns, $columnsVersion, $filterKey, $variant = 'legacy')
    {
        $this->columns = $columns;
        $this->columnsVersion = $columnsVersion;
        $this->filterKey = $filterKey;
        $this->variant = $variant;
    }

    public function updatedColumns()
    {
        $this->validate();
        $this->saveColumnSettings();
        $this->dispatch('refresh-columns');
    }

    public function refreshColumns()
    {
        $this->loadColumnSettings();
    }

    public function loadColumnSettings()
    {
        // dd($this->filterKey);
        $settings = auth()->user()->setting($this->filterKey);
        if (!empty($settings['columns']['data'])) {
            // Update visibility based on saved settings
            foreach ($settings['columns']['data'] as $column => $isVisible) {
                if (array_key_exists($column, $this->columns)) {
                    $this->columns[$column] = $isVisible;
                }
            }
        }
    }

    public function saveColumnSettings()
    {
        $filters = auth()->user()->setting($this->filterKey);
        $filters['columns'] = ['version' => $this->columnsVersion, 'data' => $this->columns];
        // dd($filters);
        auth()->user()->settings([
            $this->filterKey => $filters
        ]);
    }

    public function toggleAllColumns($value)
    {
        $this->columns = collect($this->columns)->mapWithKeys(function ($item, $key) use ($value) {
            return [$key => $value];
        })->toArray();

        $this->saveColumnSettings();
        $this->dispatch('refresh-columns');
    }

    public function render()
    {
        // dd($this->filterKey);
        // dd($this->filterKey);
        return view('livewire.column-selector');
    }
}
