<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Gate;

class BaseComponent extends Component
{
    public function prepareForValidation($attributes)
    {
        foreach ($attributes as $key => &$value) {
            if($key != "form"){
                if (is_string($value)) {
                    $value = filter_var($value, FILTER_SANITIZE_STRING);
                } elseif (is_array($value)) {
                    $value = $this->sanitizeArray($value);
                } elseif (is_object($value)) {
                    if ($value instanceof Collection) {
                        $value = $value->map(function ($item) {
                            return $this->sanitizeArray($item->toArray());
                        });
                    } else {
                        $value = $this->sanitizeArray((array) $value);
                    }
                }
            }
        }
        if(Gate::check('admin')){
            // dd('stripped');
        }
        $this->fill($attributes); // Update the form data
        return $attributes;
    }

    private function sanitizeArray(array $data)
    {
        foreach ($data as $key => &$value) {
            if (is_string($value)) {
                $value = filter_var($value, FILTER_SANITIZE_STRING);
            } elseif (is_array($value)) {
                $value = $this->sanitizeArray($value); // Recursively sanitize nested arrays
            }
        }
        return $data;
    }

    public function getHumanisedErrorsProperty()
    {
        $humanised = [];
        foreach ($this->getErrorBag()->toArray() as $attribute => $messages) {
            foreach ($messages as $message) {
                // Match dot-notation field names (e.g., orderLineEdit.exfty)
                preg_match('/\b[a-zA-Z_]+\.[a-zA-Z0-9_.]+\b/', $message, $matches);

                if (!empty($matches)) {
                    $rawFieldName = $matches[0]; // Extracted field name
                    $friendlyName = humanizeAttribute($rawFieldName); // Format it

                    // Replace only the extracted field name inside the message
                    $newMessage = str_replace($rawFieldName, $friendlyName, $message);
                } else {
                    $newMessage = $message; // Fallback if no match found
                }

                $humanised[] = $newMessage;
            }
        }
        return $humanised;
    }


    public function getHumanisedSessionMessageProperty()
    {
        $message = session('message', '');

        // This pattern matches a dot-notation string, e.g. style_versions.0.name
        $pattern = '/\b[a-z_]+\.\d+(?:\.[a-z_]+\.\d+)*\.[a-z_]+\b/i';

        // Replace each match with its humanized version
        $humanisedMessage = preg_replace_callback($pattern, function ($matches) {
            return humanizeAttribute($matches[0]);
        }, $message);

        return $humanisedMessage;
    }

    #[On('flash-error')]
    public function flashError($error){
        session()->flash('message', $error[0]);
        session()->flash('alert-class', 'alert-' . $error[1]);
    }
}
