<?php

namespace App\Http\Livewire\Admin\Yarn;

use App\Models\Count;
use Livewire\Component;
use App\Models\Materials;
use App\Models\Suppliers;
use Livewire\Attributes\On;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminYarnForm;

class YarnEdit extends Component
{
    public $yarn, $new;
    public AdminYarnForm $form;

    public function render()
    {
        Gate::authorize('style:read');
        return view('livewire.admin.yarn.yarn-edit');
    }

    #[Computed]
    public function suppliers(){
        return Suppliers::allCached();
    }
    #[Computed]
    public function counts(){
        return Count::all();
    }
    #[Computed]
    public function materials(){
        return Materials::all();
    }

    #[On('edit-yarn')]
	public function edit($yarn){
        $this->yarn = $yarn;
		$this->form->set($yarn);
	}
    #[On('new-yarn')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}
    public function save(){
        Gate::authorize('style:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }

    public function addComp(){
        $this->form->addComp();
    }
}
