<?php

namespace App\Http\Livewire\Admin\Yarn;

use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminYarnColoursForm;

class YarnColours extends Component
{
    public $yarn;
    public AdminYarnColoursForm $form;

    public function render()
    {
        Gate::authorize('style:read');
        return view('livewire.admin.yarn.yarn-colours');
    }

    #[On('edit-yarn-colours')]
	public function edit($yarn){
        $this->yarn = $yarn;
		$this->form->set($yarn);
	}

    public function addColour(){
		$this->form->addColour();
	}

    public function save(){
        Gate::authorize('style:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
