<?php

namespace App\Http\Livewire\Admin\Suppliers;

use Livewire\Component;
use App\Models\Countries;
use App\Models\SampleTypes;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminSupplierForm;

class SupplierEdit extends Component
{
    use WithFileUploads;

    public $supplier, $new;
    public AdminSupplierForm $form;

    #[Computed]
    public function countries(){
        return Countries::all();
    }

    public function render()
    {
        Gate::authorize('customer:read');
        return view('livewire.admin.suppliers.supplier-edit');
    }

    #[On('edit-supplier')]
	public function edit($supplier){
        $this->supplier = $supplier;
		$this->form->set($supplier);
	}
    #[On('new-supplier')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}

    public function newAddress(){
        $this->form->newAddress();
    }

    public function deleteAddress($i){
        $this->form->deleteAddress($i);
    }

    public function save(){
        Gate::authorize('customer:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
