<?php

namespace App\Http\Livewire\Admin\Sizes;

use Livewire\Component;
use App\Models\Countries;
use App\Models\SampleTypes;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminSizeForm;

class SizeEdit extends Component
{
    use WithFileUploads;

    public $size, $new;
    public AdminSizeForm $form;

    public function render()
    {
        Gate::authorize('order:read');
        return view('livewire.admin.sizes.size-edit');
    }

    #[On('edit-size')]
	public function edit($size){
        $this->size = $size;
		$this->form->set($size);
	}
    #[On('new-size')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}
    public function save(){
        if(!Gate::check('design:create') || !Gate::check('style:create')){
            abort(403);
        }
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
