<?php

namespace App\Http\Livewire\Admin\Seasons;

use Livewire\Component;
use App\Models\Countries;
use App\Models\SampleTypes;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminSeasonForm;

class SeasonEdit extends Component
{
    use WithFileUploads;

    public $season, $new;
    public AdminSeasonForm $form;

    public function render()
    {
        Gate::authorize('season:read');
        return view('livewire.admin.seasons.season-edit');
    }

    #[On('edit-season')]
	public function edit($season){
        $this->season = $season;
		$this->form->set($season);
	}
    #[On('new-season')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}
    public function save(){
        Gate::authorize('season:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
