<?php

namespace App\Http\Livewire\Admin\Samples;

use Livewire\Component;
use App\Models\SampleTypes;
use Illuminate\Support\Facades\Gate;

class SampleTypesEdit extends Component
{
    public $filter = ['search' => ""];
    private $sampleTypes;
    public $item;
    public $new, $edit;

    protected $rules = [
        'item.name' => 'required|string|max:35',
        'item.charge' => 'nullable|boolean',
        'item.charge_proto' => 'nullable|boolean',
        'item.charge_surcharge' => 'nullable|boolean',
	];

    public function render()
    {
        Gate::authorize('style:read');
        $this->loadData();
        return view('livewire.admin.samples.sample-types-edit', [
            'sampleTypes' => $this->sampleTypes,
        ]);
    }
    private function loadData(){
        $this->sampleTypes = SampleTypes::where('name', 'like', '%'.$this->filter['search'].'%')->paginate(100);
    }
    public function edit($sampleType){
        Gate::authorize('style:update');
        $this->item = SampleTypes::find($sampleType);
        $this->edit = TRUE;
    }
    public function new(){
        Gate::authorize('style:create');
        $this->new = TRUE;
        $this->item = new SampleTypes();
        $this->item->charge_proto = FALSE;
        $this->item->charge = TRUE;
        $this->item->charge_surcharge = TRUE;
    }
    public function save(){
        Gate::authorize('style:update');
        session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-danger');
        $validatedData = $this->validate([
            'item.name' => 'required|string|max:35',
            'item.charge' => 'nullable|boolean',
            'item.charge_proto' => 'nullable|boolean',
            'item.charge_surcharge' => 'nullable|boolean',
        ]);
        session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');
        $this->item->save();
        session()->flash('message', 'Saved');
		session()->flash('alert-class', 'alert-success');
        $this->close();
    }
    public function close(){
        $this->new = FALSE;
        $this->edit = FALSE;
        $this->dispatchBrowserEvent('closeNewModal');
        $this->loadData();
    }
}
