<?php

namespace App\Http\Livewire\Admin\SampleTypes;

use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminSampleTypeForm;

class SampleTypeEdit extends Component
{
    use WithFileUploads;

    public $sampleType, $new;
    public AdminSampleTypeForm $form;

    public function render()
    {
        Gate::authorize('style:read');
        return view('livewire.admin.sample-types.sample-type-edit');
    }

    #[On('edit-sampleType')]
	public function edit($sampleType){
        $this->sampleType = $sampleType;
		$this->form->set($sampleType);
	}
    #[On('new-sampleType')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}
    public function save(){
        Gate::authorize('style:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
