<?php

namespace App\Http\Livewire\Admin\Materials;

use Livewire\Component;
use App\Models\Countries;
use App\Models\SampleTypes;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminMaterialForm;

class MaterialEdit extends Component
{
    use WithFileUploads;

    public $material, $new;
    public AdminMaterialForm $form;

    public function render()
    {
        Gate::authorize('style:read');
        return view('livewire.admin.materials.material-edit');
    }

    #[On('edit-material')]
	public function edit($material){
        $this->material = $material;
		$this->form->set($material);
	}
    #[On('new-material')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}
    public function save(){
        Gate::authorize('style:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
