<?php

namespace App\Http\Livewire\Admin\InvoiceLayouts;

use Livewire\Component;
use App\Models\Departments;
use Livewire\Attributes\On;
use Livewire\WithPagination;
use App\Models\InvoiceLayout;
use Livewire\Attributes\Validate;
use App\Http\Livewire\BaseComponent;
use Illuminate\Support\Facades\Gate;
use App\Http\Livewire\Traits\Filterable;

class InvoiceView extends BaseComponent
{
    public $hideFilters = false;

    #[Validate([
        // 'layouts' => ['nullable', 'string', 'max:30'],
    ])]
    public $layouts;

    public function updatedLayouts($value, $propertyName)
    {
        // dd();
        // Validate individual field
        // $this->validateOnly($propertyName);

        $line = explode('.', $propertyName)[0];
        $field = explode('.', $propertyName)[1];

        $layout = InvoiceLayout::find($this->layouts[$line]['id']);


        $layout->$field = $value;
        $layout->save();
    }

    public function new()
    {
        InvoiceLayout::create([
            'name' => 'New Layout'
        ]);
    }

    #[On('close-modal')]
    public function render()
    {
        Gate::authorize('finance:update');
        $this->layouts = InvoiceLayout::get()->toArray();


        return view('livewire.admin.invoice-layouts.invoice-view');
    }
}
