<?php

namespace App\Http\Livewire\Admin\Gauges;

use Livewire\Component;
use App\Models\Countries;
use App\Models\SampleTypes;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminGaugeForm;

class GaugeEdit extends Component
{
    use WithFileUploads;

    public $gauge, $new;
    public AdminGaugeForm $form;

    public function render()
    {
        // Gate::authorize('style:read');
        return view('livewire.admin.gauges.gauge-edit');
    }

    #[On('edit-gauge')]
	public function edit($gauge){
        $this->gauge = $gauge;
		$this->form->set($gauge);
	}
    #[On('new-gauge')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}
    public function save(){
        Gate::authorize('style:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
