<?php

namespace App\Http\Livewire\Admin\Fabrics;

use App\Models\Fabric;
use Livewire\Component;
use App\Models\Suppliers;
use Livewire\WithPagination;
use App\Models\FabricManufacturer;
use Illuminate\Support\Facades\Gate;

class FabricsEdit extends Component
{
    use WithPagination;
    protected $paginationTheme = 'bootstrap';
    
    public $filter = ['search' => "", 'manufacturer' => "", 'edit' => FALSE];
    private $fabrics;
    public $fabricManufacturers;
    public $new, $edit;

    protected $rules = [
        'item.suppliers_id' => 'required|min:0|not_in:0',
        'item.code' => 'required|string|max:15',
        'item.description' => 'required|string|max:35',
	];

    public function render()
    {
        Gate::authorize('style:read');
        $this->loadData();
        return view('livewire.admin.fabrics.fabrics-edit', [
            'fabrics' => $this->fabrics,
        ]);
    }

    private function loadData(){
        $this->fabricManufacturers = Suppliers::allCached();
        $this->fabrics = Fabric::
        where(function($query) {
            if ( !empty($this->filter['manufacturer'])) {
                $query->where('suppliers_id', $this->filter['manufacturer']);
            }
        })
        ->where(function($query) {
            $query->where('description', 'like', '%'.$this->filter['search'].'%');
            $query->orwhere('code', 'like', '%'.$this->filter['search'].'%');
        })
        ->paginate(100);
    }

    public function edit($accessory){
        Gate::authorize('style:update');
        $this->item = Fabric::find($accessory);
        $this->edit = TRUE;
    }
    public function new(){
        Gate::authorize('style:create');
        $this->new = TRUE;
        $this->item = new Fabric();
        $this->item->suppliers_id = "";
    }
    public function save(){
        Gate::authorize('style:update');
        session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-danger');
        $validatedData = $this->validate([
            'item.suppliers_id' => 'required|min:0|not_in:0',
            'item.code' => 'required|string|max:15',
            'item.description' => 'required|string|max:35',
        ]);
        session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');
        $this->item->save();
        session()->flash('message', 'Saved');
		session()->flash('alert-class', 'alert-success');
        $this->close();
    }
    public function close(){
        $this->new = FALSE;
        $this->edit = FALSE;
        $this->dispatchBrowserEvent('closeNewModal');
        $this->loadData();
    }

}
