<?php

namespace App\Http\Livewire\Admin\Departments;

use Livewire\Component;
use App\Models\Countries;
use App\Models\SampleTypes;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminDepartmentForm;

class DepartmentEdit extends Component
{
    use WithFileUploads;

    public $department, $new;
    public AdminDepartmentForm $form;

    public function render()
    {
        Gate::authorize('department:read');
        return view('livewire.admin.departments.department-edit');
    }

    #[On('edit-department')]
	public function edit($department){
        $this->department = $department;
		$this->form->set($department);
	}
    #[On('new-department')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}
    public function save(){
        Gate::authorize('department:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
