<?php

namespace App\Http\Livewire\Admin\Counts;

use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Gate;
use App\Livewire\Forms\AdminCountForm;

class CountEdit extends Component
{
    use WithFileUploads;

    public $count, $new;
    public AdminCountForm $form;

    public function render()
    {
        Gate::authorize('style:read');
        return view('livewire.admin.counts.count-edit');
    }

    #[On('edit-count')]
	public function edit($count){
        $this->count = $count;
		$this->form->set($count);
	}
    #[On('new-count')]
	public function new(){
        $this->form->new();
        $this->new = TRUE;
	}
    public function save(){
        Gate::authorize('style:update');
        $this->form->update();
        $this->dispatch('close-modal');
    }
}
