<?php

namespace App\Http\Livewire\Admin\Count;

use App\Models\Count;
use App\Models\Counts;
use Livewire\Component;
use App\Models\Countries;
use Illuminate\Support\Facades\Gate;

class CountEdit extends Component
{
    public $filter = ['search' => ""];
    private $counts;
    public $item;
    public $new, $edit;

    protected $rules = [
        'item.count' => 'required|string|max:35',
	];

    public function render()
    {
        Gate::authorize('style:read');
        $this->loadData();
        return view('livewire.admin.count.count-edit', [
            'counts' => $this->counts,
        ]);
    }

    private function loadData(){
        $this->counts = Count::where('count', 'like', '%'.$this->filter['search'].'%')->paginate(100);
    }

    public function edit($count){
        Gate::authorize('style:update');
        $this->item = Count::find($count);
        $this->edit = TRUE;
    }
    public function new(){
        Gate::authorize('style:create');
        $this->new = TRUE;
        $this->item = new Count();
    }
    public function save(){
        Gate::authorize('style:update');
        session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-danger');
        $validatedData = $this->validate([
            'item.count' => 'required|string|max:35',
        ]);
        session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');
        $this->item->save();
        session()->flash('message', 'Saved');
		session()->flash('alert-class', 'alert-success');
        $this->close();
    }
    public function close(){
        $this->new = FALSE;
        $this->edit = FALSE;
        $this->dispatchBrowserEvent('closeNewModal');
        $this->loadData();
    }
}
