<?php

namespace App\Http\Controllers;

use Livewire\Livewire;
use App\Facades\ZohoFacade;
use Illuminate\Http\Request;
use App\Providers\ZohoAPIProvider;
use Illuminate\Support\Facades\Log;
use Asad\OAuth2\Client\Provider\Zoho;
use Illuminate\Http\RedirectResponse;
use League\OAuth2\Client\Provider\Exception\IdentityProviderException;

class ZohoAuthController extends Controller
{
    public function handleCallback(Request $request)
    {
        // Check the state parameter for CSRF protection
        if (empty($request->query('state')) || ($request->query('state') !== session('oauth2state'))) {
            unset($_SESSION['oauth2state']);
            abort(403, 'Invalid state');
        }

        // Exchange the authorization code for an access token
        $token = ZohoFacade::getAccessToken('authorization_code', [
            'code' => $request->query('code')
        ]);

        // Store the access token and refresh token securely
        $user = auth()->user();
        $user->zoho_access_token = serialize($token); // Serialize the token object
        $user->save();

        return response()->make("<script>window.close();</script>", 200, [
            'Content-Type' => 'text/html',
        ]);
    }
}
