<?php

namespace App\Http\Controllers;

use App\Models\CustomerOrderLineQuantities;
use App\Models\ShipmentLineSizes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class SSQuickUpdate extends Controller
{
    public function update(Request $request)
    {
        // Update Qty
        if ($request->has('qty')) {
            if (!Gate::check('order:update') && !Gate::check('finance:update')) {
                abort(403, 'Unauthorized to update quantities.');
            }
            foreach ($request->input('qty') as $dropId => $sizes) {
                foreach ($sizes as $colqId => $qty) {
                    $size = CustomerOrderLineQuantities::where('id', $colqId)->first();

                    if ($size) {
                        $size->qty = $qty;
                        $size->save();
                    }
                }
            }
        }

        // Update Shipped Qty
        if ($request->has('shipped_qty')) {
            if (!Gate::check('shipment:update') && !Gate::check('finance:update')) {
                abort(403, 'Unauthorized to update shipped quantities.');
            }
            foreach ($request->input('shipped_qty') as $dropId => $sizes) {
                foreach ($sizes as $slsId => $shippedQty) {
                    $size = ShipmentLineSizes::where('id', $slsId)->first();

                    if ($size) {
                        $size->shipped_qty = $shippedQty;
                        $size->save();
                    }
                }
            }
        }

        return response()->json(['message' => 'Shipment lines updated successfully!']);
    }
}
