<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class GoogleOAuthController extends Controller
{
    public function redirect()
    {
        $client = new \Google_Client();
        $client->setClientId(config('services.google.client_id'));
        $client->setClientSecret(config('services.google.client_secret'));
        $client->setRedirectUri(config('services.google.redirect_uri'));
        $client->addScope(\Google_Service_Sheets::SPREADSHEETS);
        $client->addScope(\Google_Service_Drive::DRIVE_FILE);
        $client->setAccessType('offline');
        $client->setPrompt('consent');
        
        $authUrl = $client->createAuthUrl();
        
        return redirect($authUrl);
    }
    
    public function callback(Request $request)
    {
        try {
            $client = new \Google_Client();
            $client->setClientId(config('services.google.client_id'));
            $client->setClientSecret(config('services.google.client_secret'));
            $client->setRedirectUri(config('services.google.redirect_uri'));
            
            $token = $client->fetchAccessTokenWithAuthCode($request->code);
            
            if (isset($token['error'])) {
                Log::error('Google OAuth Error: ' . json_encode($token));
                return redirect()->back()->with('error', 'Failed to connect to Google: ' . $token['error']);
            }
            
            $user = auth()->user();
            $user->google_access_token = $token['access_token'];
            $user->google_refresh_token = $token['refresh_token'] ?? $user->google_refresh_token;
            $user->google_token_expires_at = now()->addSeconds($token['expires_in']);
            $user->save();
            
            return redirect()->back()->with('success', 'Successfully connected to Google! You can now export to Google Sheets.');
            
        } catch (\Exception $e) {
            Log::error('Google OAuth Callback Error: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Failed to connect to Google: ' . $e->getMessage());
        }
    }
}









































































