<?php

namespace App\Helper;

use Exception;
use App\Models\Seasons;

class Conversions
{
	public static function convertCurrency($currencyIn, $currencyOut, $value, $season){
		if(is_int($season)){
            $season = Seasons::find($season);
        }
		if($currencyIn != NULL && $currencyOut != NULL && $value != NULL && $season != NULL && $value != 0 && $value != ''){
			switch($currencyOut){
				case '£':
					switch($currencyIn){
						case '£':
							return $value;
						case '€':
							return $value / $season->euro_rate;
						case '$':
							return $value / $season->usd_rate;
					}
				case '€':
					switch($currencyIn){
						case '£':
							return $value * $season->euro_rate;
						case '€':
							return $value;
						case '$':
							return $value * $season->euro_rate / $season->usd_rate;
					}
				case '$':
					switch($currencyIn){
						case '£':
							return $value * $season->usd_rate;
						case '€':
							return $value * $season->usd_rate / $season->euro_rate;
						case '$':
							return $value;
					}
			}
		}
		else{
			return 0;
		}
	}
}
