<?php

namespace App\Exports;

use App\Models\Styles;
use App\Models\Seasons;
use App\Models\Customer;
use App\Models\Suppliers;
use App\Models\Colourways;
use App\Models\Gauge;
use App\Models\Departments;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;



class DevFactoryReportExport implements FromView
{

    public function view(): View
    {
        //$this->getfilter();
        $filter = auth()->user()->setting('report-dev-filter');
        return view('livewire.reports.development.dev-factory-report-export', [
            'styles' => Styles::with(['designs',
            'customers',
            'version_to_use.factories',
            'version_to_use.colourways.style_versions.gauges',
            'version_to_use.colourways.style_versions.styles.customers',
            'version_to_use.colourways.colourway_yarns.yarns.yarn_compositions.materials',
            'version_to_use.colourways.samples.sample_types'])->get(),

            'seasons' => Seasons::select('id', 'description')->get(),
            'departments' => Departments::select('id', 'description')->get(),
            'customers' => Customer::select('id', 'name')->get(),
            'factories' => Suppliers::where('type', 'factory')->get(),
            'gauges' => Gauge::get(),
            'filter' => $filter,
        ]);
    }


    public function getGCS($file){
        return $this->gcs->url($file);
    }
}