<?php

namespace App\Exceptions;

use Exception;

class ZohoAuthRequiredException extends Exception
{
    protected string $authUrl;

    public function __construct(string $authUrl, $message = 'Zoho authentication required')
    {
        parent::__construct($message);
        $this->authUrl = $authUrl;
    }

    public function getAuthUrl(): string
    {
        return $this->authUrl;
    }
}
