<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        
        // Rebuild all price and total caches every Sunday at 1am
        // This ensures any missed invalidations or edge cases are caught
        $schedule->command('cache:rebuild-all --force')
            ->weeklyOn(0, '01:00') // Sunday at 1am
            ->timezone('Europe/London')
            ->runInBackground()
            ->withoutOverlapping()
            ->onSuccess(function () {
                Log::info('Scheduled cache rebuild completed successfully');
            })
            ->onFailure(function () {
                Log::error('Scheduled cache rebuild failed');
            });
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
