<?php

namespace App\Console\Commands;

use App\Services\PriceResolutionService;
use Illuminate\Console\Command;

class PriceResolutionsStats extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'price-resolutions:stats';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Show price resolution cache statistics';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Price Resolution Cache Statistics');
        $this->info('=================================');

        $service = app(PriceResolutionService::class);
        $stats = $service->getCacheStats();

        $this->table(
            ['Metric', 'Value'],
            [
                ['Total Resolutions', $stats['total']],
                ['Fresh Resolutions', $stats['fresh']],
                ['Stale Resolutions', $stats['stale']],
                ['Fresh Percentage', $stats['fresh_percentage'] . '%'],
            ]
        );

        // Show breakdown by freshness
        if ($stats['total'] > 0) {
            $this->newLine();
            $this->info('Cache Health:');
            
            if ($stats['fresh_percentage'] >= 90) {
                $this->info('✅ Excellent - Cache is well maintained');
            } elseif ($stats['fresh_percentage'] >= 75) {
                $this->info('⚠️  Good - Some stale entries present');
            } elseif ($stats['fresh_percentage'] >= 50) {
                $this->warn('⚠️  Fair - Many stale entries, consider cleanup');
            } else {
                $this->error('❌ Poor - Cache needs attention');
            }
        } else {
            $this->warn('No price resolutions found. Run backfill command to populate cache.');
        }

        return 0;
    }
}
