# NRW Web - Pricing Strategy

## 💰 Recommended Pricing Tiers

### **Starter - £10/month**
**Best for: Individual photographers, small portfolios**

**Limits:**
- 500 photos
- 5 GB storage
- 25 GB bandwidth/month
- 5 albums
- 15 MB max file size

**Typical Cost to You:** £1.00/month (90% profit margin)  
**Max Cost to You:** £3.10/month (if they max out bandwidth)

**Marketing Message:**
> "Perfect for showcasing your best work. Upload up to 500 photos across 5 beautiful albums. Ideal for wedding photographers sharing a season's highlights."

---

### **Professional - £25/month**
**Best for: Active photographers, multiple clients**

**Limits:**
- 2,000 photos
- 20 GB storage
- 100 GB bandwidth/month
- 20 albums
- 25 MB max file size

**Typical Cost to You:** £4.00/month (84% profit margin)  
**Max Cost to You:** £12.40/month

**Marketing Message:**
> "For busy professionals managing multiple shoots. Host up to 2,000 photos with unlimited views. Perfect for photographers with 5-10 client galleries per month."

---

### **Business - £75/month**
**Best for: Studios, high-volume photographers**

**Limits:**
- 10,000 photos
- 100 GB storage
- 500 GB bandwidth/month
- Unlimited albums
- 50 MB max file size

**Typical Cost to You:** £30/month (60% profit margin)  
**Max Cost to You:** £67/month

**Marketing Message:**
> "Built for photography businesses. Store thousands of photos, create unlimited albums, and share with confidence. Enterprise-grade performance for professional studios."

---

### **Enterprise - Custom Pricing**
**Best for: Large studios, agencies, multi-photographer teams**

**Starting at:** £150/month

**Limits:**
- Unlimited photos
- 1 TB storage
- 5 TB bandwidth/month
- Unlimited albums
- 100 MB max file size

**Typical Cost to You:** £50-100/month (33-67% profit margin)

**Marketing Message:**
> "White-glove service for established businesses. Unlimited photos, priority support, custom domain included. Let's discuss your specific needs."

---

## 🎯 Pricing Psychology

### Why These Prices Work

1. **£10 Entry Point** - Low enough to try, high enough to be taken seriously
2. **2.5x Jump to Pro** - Creates clear value differentiation
3. **3x Jump to Business** - Positions as premium tier
4. **£75 Business Tier** - Sweet spot for professional studios (competing with £50-150/month solutions)

### Value-Based Pricing

Most competitors charge:
- **SmugMug**: $7-40/month (but limited features)
- **Zenfolio**: $5-50/month (clunky interface)
- **Pixieset**: $8-25/month (limited storage)
- **PhotoShelter**: $10-50/month (outdated)

**Your advantage:** Modern UI, unlimited views, simple pricing, no surprises.

---

## 📊 Revenue Projections

### Conservative (First Year)

| Tier | Customers | Monthly Revenue | Monthly Cost | Monthly Profit |
|------|-----------|-----------------|--------------|----------------|
| Starter | 20 | £200 | £20 | £180 |
| Professional | 10 | £250 | £40 | £210 |
| Business | 3 | £225 | £90 | £135 |
| **Total** | **33** | **£675** | **£150** | **£525/month** |

**Annual Profit:** £6,300

### Growth (Year 2)

| Tier | Customers | Monthly Revenue | Monthly Cost | Monthly Profit |
|------|-----------|-----------------|--------------|----------------|
| Starter | 50 | £500 | £50 | £450 |
| Professional | 30 | £750 | £120 | £630 |
| Business | 10 | £750 | £300 | £450 |
| Enterprise | 2 | £300 | £120 | £180 |
| **Total** | **92** | **£2,300** | **£590** | **£1,710/month** |

**Annual Profit:** £20,520

### Established (Year 3+)

| Tier | Customers | Monthly Revenue | Monthly Cost | Monthly Profit |
|------|-----------|-----------------|--------------|----------------|
| Starter | 100 | £1,000 | £100 | £900 |
| Professional | 75 | £1,875 | £300 | £1,575 |
| Business | 25 | £1,875 | £750 | £1,125 |
| Enterprise | 5 | £750 | £300 | £450 |
| **Total** | **205** | **£5,500** | **£1,450** | **£4,050/month** |

**Annual Profit:** £48,600

---

## 🎁 Promotional Strategies

### Launch Pricing (First 3 Months)
- **50% off first month** - Gets them in the door
- **14-day free trial** - Let them experience the product
- **Lifetime discount** - "First 100 customers get £5 off forever"

### Annual Discounts
- Pay annually, get **2 months free** (16% discount)
- Improves cash flow
- Reduces churn

Example:
- Starter: £120/year (vs £120/year monthly) → £100/year
- Professional: £300/year (vs £300/year monthly) → £250/year
- Business: £900/year (vs £900/year monthly) → £750/year

### Referral Program
- **Give £10, Get £10** - Customer refers a friend
- **Agency Partnerships** - 20% commission for referrals
- **Influencer Deals** - Free Business tier for testimonial + promotion

---

## 💬 Sales Messaging

### For Wedding Photographers
> "Stop paying per-gallery fees. One simple price for unlimited client galleries. Upload a season's worth of weddings and share with confidence."

### For Portrait Photographers
> "Give your clients a beautiful gallery experience. No downloads, no ads, just your stunning photos front and center."

### For Event Photographers
> "Share event photos with attendees instantly. Branded galleries, fast loading, private access codes. Done in minutes, not hours."

### For Studios
> "One platform for your entire team. Create galleries for every client, every shoot, every project. Simple pricing that scales with your business."

---

## 🚀 Upsell Opportunities

### Add-Ons (Future)
- **Custom Domain**: +£5/month (costs you £0)
- **Priority Support**: +£10/month (costs you time)
- **White-Label Branding**: +£15/month (costs you £0)
- **Multiple Users/Team**: +£20/month (costs you £0)
- **Advanced Analytics**: +£10/month (costs you £1)

### Professional Services
- **Setup Service**: £100 one-time (2 hours of your time)
- **Custom Design**: £250 one-time (4 hours of your time)
- **Migration Service**: £50-200 (import from competitors)
- **Photography Training**: £50/hour (if you're a photographer!)

---

## 🎯 Target Customer Acquisition Cost (CAC)

### Organic (SEO, Word of Mouth)
- **Target CAC**: £0-10
- **Lifetime Value (LTV)**: £180-900 (18 months avg)
- **LTV/CAC Ratio**: 18-90x (excellent!)

### Paid Ads (Facebook, Google)
- **Target CAC**: £20-50
- **Lifetime Value (LTV)**: £180-900
- **LTV/CAC Ratio**: 3.6-45x (good)

### Agency Partnerships
- **Cost**: 20% commission ongoing
- **Net Revenue**: £8/16/60 per month
- **Worthwhile**: Yes, if they bring >10 customers

---

## 📈 Churn Management

### Expected Churn Rates
- **Starter**: 5-8% monthly (seasonal photographers)
- **Professional**: 3-5% monthly (established, stickier)
- **Business**: 1-2% monthly (very sticky)
- **Enterprise**: 0-1% monthly (contracts)

### Reducing Churn
1. **Onboarding emails** - 7-day series teaching features
2. **Usage alerts** - "You're at 80% capacity, time to upgrade?"
3. **Win-back campaigns** - "We miss you! Come back for 50% off"
4. **Exit surveys** - Learn why they left
5. **Annual contracts** - Lock in for 12 months

---

## 🔄 Customer Journey

### Month 1-2: Acquisition
- Free trial or 50% off first month
- Hand-holding onboarding
- Quick wins (first gallery live in 10 minutes)

### Month 3-6: Activation
- Regular usage
- Positive customer support interactions
- Maybe hitting limits → upgrade conversation

### Month 7-12: Growth
- Outgrowing current tier
- Upsell to next tier
- Add-on services

### Month 13+: Retention
- Annual renewal
- Brand advocate
- Referral source

---

## 💡 Competitive Positioning

| Feature | NRW Web | SmugMug | Zenfolio | Pixieset |
|---------|---------|---------|----------|----------|
| **Modern UI** | ✅ Best | ❌ Dated | ❌ Clunky | ✅ Good |
| **Unlimited Views** | ✅ Yes | ✅ Yes | ✅ Yes | ⚠️ Limited |
| **No Per-Gallery Fees** | ✅ Yes | ✅ Yes | ❌ Extra | ⚠️ Varies |
| **Fast Loading** | ✅ CDN | ✅ Good | ⚠️ Slow | ✅ Good |
| **Price (Pro tier)** | £25 | $30-40 | $25-50 | $16-25 |
| **Easy Setup** | ✅ 5 mins | ⚠️ 30 mins | ⚠️ 45 mins | ✅ 10 mins |

**Your Edge:** Simplest, fastest, best-looking galleries at competitive pricing.

---

## 🎓 Marketing Channels

### Primary (Launch)
1. **Photography Facebook Groups** - Free, targeted
2. **Instagram** - Showcase beautiful galleries
3. **Reddit** (r/WeddingPhotography, r/AskPhotography)
4. **Pinterest** - Visual discovery

### Secondary (Growth)
1. **Google Ads** - "Photo gallery hosting"
2. **Facebook Ads** - Target wedding photographers
3. **Photography Podcasts** - Sponsorships
4. **Photography Forums** - Helpful member → signature link

### Tertiary (Scale)
1. **Photography Conferences** - Booth at WPPI, PhotoPlus
2. **YouTube Creators** - Sponsored videos
3. **Photography Schools** - Student discount program
4. **Camera Store Partnerships** - Cross-promotion

---

## ✅ Action Plan

### Week 1
- [ ] Set up Stripe for payments
- [ ] Create simple landing page
- [ ] Post in 10 Facebook groups
- [ ] Get first 3 beta customers (free)

### Month 1
- [ ] Launch with 50% off promotion
- [ ] Target: 10 paying customers
- [ ] Collect testimonials
- [ ] Refine onboarding

### Month 3
- [ ] Target: 30 paying customers
- [ ] Launch referral program
- [ ] Start paid ads (£100/month budget)
- [ ] Revenue: £300-600/month

### Month 6
- [ ] Target: 60 paying customers
- [ ] Scale paid ads (£500/month budget)
- [ ] Revenue: £1,000-1,500/month
- [ ] Hire part-time support

### Month 12
- [ ] Target: 100 paying customers
- [ ] Revenue: £2,000-3,000/month
- [ ] Consider full-time
- [ ] Launch add-on services

---

**Good luck! You've got a great product at the right price.** 🚀

