# AI Assistant - Example Usage Scenarios

This document provides detailed examples of how to use the AI Assistant plugin effectively.

## 📚 Table of Contents

1. [Content Management Examples](#content-management)
2. [Module Management Examples](#module-management)
3. [SP Page Builder Examples](#sp-page-builder)
4. [Complex Multi-Step Examples](#complex-multi-step)
5. [Information Retrieval Examples](#information-retrieval)

---

## Content Management

### Example 1: Update Existing Article

**User Prompt:**
```
Update article ID 42 to change the title to "New Product Launch 2025" 
and add a note that early bird pricing ends January 15th
```

**AI Response:**
```
I'll help you update article 42. Let me break this down:

Actions planned:
1. Read article 42 to get current content
2. Update the article with new title and modified content

Executing...

✓ read_article: Retrieved article "Old Product Launch"
✓ update_article: Updated successfully
  - Changed title to "New Product Launch 2025"
  - Added early bird pricing information to intro text

Task completed. Article has been updated.
```

### Example 2: Create New Article

**User Prompt:**
```
Create a new article called "Summer Event 2025" in the Events category. 
Make it featured and set it to publish on June 1st, 2025. Include a brief intro 
saying "Join us for our annual summer celebration!"
```

**AI Response:**
```
I'll create that article for you. Planning actions...

Actions:
1. Search for Events category ID
2. Create the new article with your specifications

Executing...

✓ search_articles: Found Events category (ID: 5)
✓ create_article: Created article successfully
  - ID: 127
  - Title: "Summer Event 2025"
  - Category: Events (5)
  - Featured: Yes
  - Publish date: 2025-06-01
  - Intro text added

Task completed. Your new article is ready (ID: 127).
```

### Example 3: Find and Update Multiple Articles

**User Prompt:**
```
Find all articles with "COVID" in the title and update them to add a note 
at the top saying "This information may be outdated. Last updated: [date]"
```

**AI Response:**
```
I'll search for articles with "COVID" and update them. This will require review.

Actions planned:
1. Search articles with "COVID" in title
2. For each found article:
   - Read current content
   - Prepend the outdated notice
   - Update the article

Search found 8 articles. Showing planned updates:

✓ read_article (ID: 45): "COVID-19 Safety Guidelines"
📝 update_article: Will prepend outdated notice

✓ read_article (ID: 52): "COVID Testing Locations"  
📝 update_article: Will prepend outdated notice

... (6 more articles)

[Review Required]
Click "Execute All" to apply these changes, or review each individually.
```

---

## Module Management

### Example 4: Update Footer Module

**User Prompt:**
```
Find the footer copyright module and update it to show copyright year 2025 
and change the company name to "Acme Corp International"
```

**AI Response:**
```
I'll locate and update the footer copyright module.

Actions:
1. List modules to find footer copyright
2. Read the module content
3. Update with new information

Executing...

✓ list_modules: Found 3 footer modules
✓ read_module (ID: 15): "Copyright Footer"
✓ update_module: Updated successfully
  - Changed year to 2025
  - Updated company name to "Acme Corp International"
  - Previous: "© 2024 Acme Corp"
  - New: "© 2025 Acme Corp International"

Task completed. Footer has been updated.
```

### Example 5: Update Contact Information

**User Prompt:**
```
Update our contact info module with the new address:
123 Main Street, Suite 500
New York, NY 10001
And change the phone to +1-555-0199
```

**AI Response:**
```
I'll update the contact information module.

Actions planned:
1. Search for contact info module
2. Update with new address and phone

Executing...

✓ list_modules: Found "Contact Information" (ID: 8)
✓ read_module: Retrieved current parameters
✓ update_module: Updated successfully
  - Address updated
  - Phone changed from +1-555-0100 to +1-555-0199
  - Module remains published in sidebar-right

Task completed. Contact information has been updated.
```

---

## SP Page Builder

### Example 6: Update Hero Section

**User Prompt:**
```
On the homepage (Page Builder page ID 1), change the hero heading to 
"Welcome to Our New Store" and update the subheading to 
"Discover amazing products at unbeatable prices"
```

**AI Response:**
```
I'll update the homepage hero section.

Actions:
1. Read Page Builder page 1
2. Locate hero section
3. Update heading and subheading

Executing...

✓ read_pagebuilder_page (ID: 1): "Home"
  - Found hero section in row 1
✓ update_pagebuilder_page: Updated successfully
  - Changed heading from "Welcome to Our Store"
  - Changed subheading text
  - Preserved all other section content and styling

Task completed. Homepage hero section has been updated.
```

### Example 7: Add Promotional Banner

**User Prompt:**
```
Add a promotional notice to the top of our homepage:
"WINTER SALE: 30% OFF EVERYTHING - Use code WINTER30"
Make it prominent and attention-grabbing.
```

**AI Response:**
```
I'll add a promotional banner to your homepage.

Actions planned:
1. Read current homepage structure
2. Add new section at the top with promotional text

Note: This will require reviewing the exact section structure, as adding 
new Page Builder sections involves complex JSON manipulation.

✓ read_pagebuilder_page (ID: 1): Retrieved structure
📝 update_pagebuilder_page: Will add new row with text addon
  - Position: Top (row 0)
  - Style: Alert/Attention style
  - Content: "WINTER SALE: 30% OFF EVERYTHING - Use code WINTER30"

[Review Required]
Please review the Page Builder JSON structure before applying.
```

---

## Complex Multi-Step

### Example 8: New Product Launch

**User Prompt:**
```
We're launching a new product called "SuperWidget X1". Please:
1. Create an article about it in the Products category
2. Add a featured banner to the homepage
3. Update the main navigation to add a "New Products" menu item
4. Update the footer to mention the launch date of January 15, 2025
```

**AI Response:**
```
I'll help you launch SuperWidget X1. This is a multi-step process.

Planning 8 actions...

Step 1: Create Product Article
✓ search_articles: Found Products category (ID: 7)
✓ create_article: Created "SuperWidget X1" (ID: 156)
  - Category: Products
  - Status: Published
  - Featured: Yes

Step 2: Update Homepage Banner
✓ read_pagebuilder_page: Retrieved homepage
✓ update_pagebuilder_page: Added featured banner
  - Position: Top banner section
  - Content: "Introducing SuperWidget X1"

Step 3: Update Navigation
✓ read_menu: Retrieved main menu structure
✓ update_menu: Added "New Products" item
  - Position: After "Products" menu item
  - Link: Points to new article

Step 4: Update Footer
✓ read_module: Retrieved footer module
✓ update_module: Added launch date notice
  - Added: "New SuperWidget X1 launching January 15, 2025"

Task completed! Your product launch is ready:
- Article created (ID: 156)
- Homepage updated
- Menu navigation updated
- Footer announcement added
```

### Example 9: Content Cleanup

**User Prompt:**
```
Our site needs cleanup:
1. Find all unpublished articles older than 1 year
2. Find all empty modules (no content)
3. Give me a report of what you find
Don't delete anything, just report.
```

**AI Response:**
```
I'll audit your site for cleanup opportunities.

Scanning...

✓ search_articles: Searching unpublished articles
  Found: 23 unpublished articles

  Filtering by date (older than 1 year)...
  - 12 articles older than 1 year
  - Oldest: "2023 Event" from January 2023
  - Newest old article: "Draft Post" from November 2023

✓ list_modules: Searching all modules
✓ read_module: Checking for empty content (repeated for all modules)

  Found: 5 modules with empty content
  - Module ID 34: "Empty Custom HTML" (unpublished)
  - Module ID 41: "Placeholder Module" (unpublished)
  - Module ID 67: "Test Module" (published - position: debug)
  - Module ID 72: "Unused Banner" (unpublished)
  - Module ID 89: "Old Sidebar" (unpublished)

CLEANUP REPORT:
==============
Old Unpublished Articles: 12
Empty Modules: 5 (1 published, 4 unpublished)

Recommendations:
1. Review old unpublished articles - likely safe to delete
2. Remove or populate empty modules
3. Module ID 67 is published but empty - should be addressed

Would you like me to help clean these up?
```

---

## Information Retrieval

### Example 10: Site Audit

**User Prompt:**
```
Give me an overview of my site:
- How many articles do I have?
- What categories have the most content?
- How many modules are published?
- What's my current Joomla version?
```

**AI Response:**
```
I'll gather that information for you.

Running site audit...

✓ get_site_info: Retrieved system information
✓ search_articles: Counting all articles
✓ search_articles: Analyzing by category
✓ list_modules: Counting modules

SITE OVERVIEW:
=============

System Information:
- Site: "My Awesome Joomla Site"
- Joomla Version: 5.2.1
- PHP Version: 8.2.15
- Active Template: Cassiopeia
- Database: MySQL 8.0

Content Statistics:
- Total Articles: 247
- Published: 198
- Unpublished: 49
- Featured: 12

Top Categories:
1. Blog (67 articles)
2. News (43 articles)
3. Products (31 articles)
4. Events (28 articles)
5. Tutorials (24 articles)

Module Statistics:
- Total Modules: 45
- Published: 32
- Unpublished: 13

Most Common Positions:
- sidebar-right: 8 modules
- footer: 6 modules
- menu: 4 modules

Your site is healthy with a good content distribution!
```

### Example 11: Find Specific Content

**User Prompt:**
```
I need to find articles about "Black Friday" that were published in 2023.
Show me their titles and IDs so I can update them for 2024.
```

**AI Response:**
```
Searching for Black Friday articles from 2023...

✓ search_articles: Found articles matching criteria

RESULTS:
=======

Found 5 articles about "Black Friday" from 2023:

1. ID: 134 - "Black Friday Deals 2023"
   Published: 2023-11-15
   Category: Promotions
   Status: Published

2. ID: 138 - "Black Friday Shopping Guide"
   Published: 2023-11-20
   Category: Blog
   Status: Published

3. ID: 142 - "Best Black Friday Tech Deals"
   Published: 2023-11-22
   Category: Tech
   Status: Published

4. ID: 145 - "Black Friday Sale Extended!"
   Published: 2023-11-27
   Category: Promotions
   Status: Published

5. ID: 151 - "Black Friday Wrap-up 2023"
   Published: 2023-12-01
   Category: News
   Status: Unpublished

Would you like me to update these for 2024? I can:
- Change "2023" to "2024" in titles
- Update publish dates
- Mark as featured
- Update content to reflect new dates
```

---

## Tips for Effective Prompts

### ✅ Good Prompts

- **Specific**: "Update article 42's title to 'New Title'"
- **Clear Intent**: "Find all unpublished articles and list them"
- **Step-by-step**: "First find the footer module, then update its contact info"
- **Context**: "On the homepage hero section, change the heading"

### ❌ Avoid These

- **Vague**: "Fix the site"
- **Ambiguous**: "Update the thing"
- **Overly Complex**: Single prompt with 20 different unrelated tasks
- **Missing Context**: "Change it" (change what?)

### 💡 Best Practices

1. **Start Simple**: Test with read operations first
2. **Use Review Mode**: Especially for bulk operations
3. **Be Specific**: Include IDs or unique identifiers when possible
4. **Break Down Complex Tasks**: The AI will handle multi-step, but clarity helps
5. **Provide Context**: Mention what page, section, or area you're referring to

---

## Common Patterns

### Pattern: Find-Read-Update
```
"Find the contact module, read its current content, 
then update the email to info@newdomain.com"
```

### Pattern: Create-Configure-Publish
```
"Create a new article called 'Event', put it in the Events category,
make it featured, and publish it on March 1st"
```

### Pattern: Audit-Report
```
"Check all my modules and tell me which ones are published 
but have no content"
```

### Pattern: Bulk Update
```
"Find all articles in the Archive category and add a disclaimer 
at the top of each one"
```

---

## Need Help?

If you're not getting the results you expect:

1. **Review the action log** - See what the AI actually tried to do
2. **Be more specific** - Add more details to your prompt
3. **Break it down** - Split complex tasks into smaller prompts
4. **Check permissions** - Ensure the action type is enabled
5. **Use review mode** - Preview actions before execution

Remember: The AI learns from your prompts. The clearer and more specific you are, the better the results!

