<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.aiassistant
 *
 * @copyright   Copyright (C) 2025 Open Source Matters. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;

// Load plugin parameters for branding
$db = Factory::getDbo();
$query = $db->getQuery(true)
    ->select($db->quoteName('params'))
    ->from($db->quoteName('#__extensions'))
    ->where($db->quoteName('element') . ' = ' . $db->quote('aiassistant'))
    ->where($db->quoteName('folder') . ' = ' . $db->quote('system'));
$db->setQuery($query);
$paramsJson = $db->loadResult();
$params = new \Joomla\Registry\Registry($paramsJson);

// Get branding settings with defaults
$consoleTitle = $params->get('console_title', 'AI Assistant Console');
$welcomeHeading = $params->get('console_welcome_heading', 'Welcome to AI Assistant');
$welcomeText = $params->get('console_welcome_text', 'I can help you manage your Joomla site. Try asking me to:');
$customLogo = $params->get('custom_logo', '');

// Get color settings with defaults
$primaryColor = $params->get('primary_color', '#3b82f6');
$primaryHoverColor = $params->get('primary_hover_color', '#2563eb');
$secondaryColor = $params->get('secondary_color', '#64748b');
$successColor = $params->get('success_color', '#10b981');
$warningColor = $params->get('warning_color', '#f59e0b');
$errorColor = $params->get('error_color', '#ef4444');
$bgColor = $params->get('background_color', '#ffffff');
$bgAltColor = $params->get('background_alt_color', '#f8fafc');
$borderColor = $params->get('border_color', '#e2e8f0');
$textColor = $params->get('text_color', '#1e293b');
$textMutedColor = $params->get('text_muted_color', '#64748b');
$thinkingGradientStart = $params->get('thinking_gradient_start', '#667eea');
$thinkingGradientEnd = $params->get('thinking_gradient_end', '#764ba2');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($consoleTitle); ?></title>
    <link rel="stylesheet" href="<?php echo Uri::root(); ?>media/plg_system_aiassistant/css/console.css">
    <style>
        /* Dynamic branding colors from admin settings */
        :root {
            --ai-primary: <?php echo htmlspecialchars($primaryColor); ?>;
            --ai-primary-hover: <?php echo htmlspecialchars($primaryHoverColor); ?>;
            --ai-secondary: <?php echo htmlspecialchars($secondaryColor); ?>;
            --ai-success: <?php echo htmlspecialchars($successColor); ?>;
            --ai-warning: <?php echo htmlspecialchars($warningColor); ?>;
            --ai-error: <?php echo htmlspecialchars($errorColor); ?>;
            --ai-bg: <?php echo htmlspecialchars($bgColor); ?>;
            --ai-bg-alt: <?php echo htmlspecialchars($bgAltColor); ?>;
            --ai-border: <?php echo htmlspecialchars($borderColor); ?>;
            --ai-text: <?php echo htmlspecialchars($textColor); ?>;
            --ai-text-muted: <?php echo htmlspecialchars($textMutedColor); ?>;
            --ai-thinking-gradient-start: <?php echo htmlspecialchars($thinkingGradientStart); ?>;
            --ai-thinking-gradient-end: <?php echo htmlspecialchars($thinkingGradientEnd); ?>;
            --ai-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
            --ai-shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    <div id="ai-console-app" class="ai-console">
        <!-- Header -->
        <header class="ai-console-header">
            <h1>
                <?php if (!empty($customLogo)): ?>
                    <img src="<?php echo Uri::root() . htmlspecialchars($customLogo); ?>" alt="Logo" class="ai-icon" style="width: 32px; height: 32px; object-fit: contain;">
                <?php else: ?>
                    <svg class="ai-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                    </svg>
                <?php endif; ?>
                <?php echo htmlspecialchars($consoleTitle); ?>
            </h1>
            <div class="ai-console-controls">
                <button id="history-btn" class="btn btn-secondary" title="View session history">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <polyline points="12 6 12 12 16 14"/>
                    </svg>
                    History
                </button>
                <button id="test-api-btn" class="btn btn-secondary" title="Test API configuration">
                    🔧 Test API
                </button>
                <button id="view-logs-btn" class="btn btn-secondary" title="View recent logs">
                    📋 View Logs
                </button>
                <button id="settings-btn" class="btn btn-secondary" title="Configure plugin settings">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="3"/>
                        <path d="M12 1v6m0 6v6M4.22 4.22l4.24 4.24m7.08 7.08l4.24 4.24M1 12h6m6 0h6M4.22 19.78l4.24-4.24m7.08-7.08l4.24-4.24"/>
                    </svg>
                    Settings
                </button>
            </div>
        </header>

        <!-- Main Content -->
        <div class="ai-console-main">
            <!-- Conversation Area -->
            <div class="ai-conversation" id="conversation">
                <div class="ai-welcome">
                    <h2><?php echo htmlspecialchars($welcomeHeading); ?></h2>
                    <p><?php echo htmlspecialchars($welcomeText); ?></p>
                    <ul class="ai-suggestions">
                        <li>"Update the homepage hero section to announce our Winter Sale"</li>
                        <li>"Find all unpublished articles about events"</li>
                        <li>"Change the footer contact information"</li>
                        <li>"List all modules in the sidebar-right position"</li>
                        <li>"Create a new article about our latest product"</li>
                    </ul>
                </div>
            </div>

            <!-- Input Area -->
            <div class="ai-input-area">
                <div class="ai-input-wrapper">
                    <textarea 
                        id="prompt-input" 
                        class="ai-input" 
                        placeholder="Ask me to do something with your Joomla site..."
                        rows="3"
                    ></textarea>
                    <div class="ai-input-actions">
                        <label class="ai-checkbox">
                            <input type="checkbox" id="require-review">
                            <span>Review before applying changes (disabled = auto-execute)</span>
                        </label>
                        <button id="submit-btn" class="btn btn-primary">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <line x1="22" y1="2" x2="11" y2="13"/>
                                <polygon points="22 2 15 22 11 13 2 9 22 2"/>
                            </svg>
                            Send
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- History Sidebar -->
        <div id="history-sidebar" class="ai-sidebar ai-history-sidebar">
            <div class="ai-sidebar-header">
                <h3>Session History</h3>
                <button id="close-history" class="btn-close">&times;</button>
            </div>
            <div class="ai-sidebar-content" id="history-list">
                <div class="ai-loading">Loading history...</div>
            </div>
        </div>

        <!-- Action Review Modal -->
        <div id="review-modal" class="ai-modal">
            <div class="ai-modal-content">
                <div class="ai-modal-header">
                    <h3>Review Actions</h3>
                    <button class="btn-close" id="close-review">&times;</button>
                </div>
                <div class="ai-modal-body" id="review-actions">
                    <!-- Actions will be inserted here -->
                </div>
                <div class="ai-modal-footer">
                    <button id="execute-all-btn" class="btn btn-primary">Execute All</button>
                    <button id="cancel-review-btn" class="btn btn-secondary">Cancel</button>
                </div>
            </div>
        </div>

        <!-- Loading Overlay -->
        <div id="loading-overlay" class="ai-loading-overlay" style="display: none;">
            <div class="ai-spinner"></div>
            <p>AI is thinking...</p>
        </div>
    </div>

    <script>
        // Pass configuration and branding to JavaScript
        window.AI_ASSISTANT_CONFIG = {
            baseUrl: '<?php echo Uri::root(); ?>',
            token: '<?php echo \Joomla\CMS\Session\Session::getFormToken(); ?>',
            branding: {
                title: <?php echo json_encode($consoleTitle); ?>,
                welcomeHeading: <?php echo json_encode($welcomeHeading); ?>,
                welcomeText: <?php echo json_encode($welcomeText); ?>,
                logo: <?php echo json_encode($customLogo); ?>,
                colors: {
                    primary: <?php echo json_encode($primaryColor); ?>,
                    primaryHover: <?php echo json_encode($primaryHoverColor); ?>,
                    secondary: <?php echo json_encode($secondaryColor); ?>,
                    success: <?php echo json_encode($successColor); ?>,
                    warning: <?php echo json_encode($warningColor); ?>,
                    error: <?php echo json_encode($errorColor); ?>,
                    bg: <?php echo json_encode($bgColor); ?>,
                    bgAlt: <?php echo json_encode($bgAltColor); ?>,
                    border: <?php echo json_encode($borderColor); ?>,
                    text: <?php echo json_encode($textColor); ?>,
                    textMuted: <?php echo json_encode($textMutedColor); ?>,
                    thinkingGradientStart: <?php echo json_encode($thinkingGradientStart); ?>,
                    thinkingGradientEnd: <?php echo json_encode($thinkingGradientEnd); ?>
                }
            }
        };
    </script>
    <script src="<?php echo Uri::root(); ?>media/plg_system_aiassistant/js/console.js"></script>
</body>
</html>

