<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.aiassistant
 *
 * @copyright   Copyright (C) 2025 Open Source Matters. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo Text::_('PLG_SYSTEM_AIASSISTANT_CONSOLE_TITLE'); ?></title>
    <link rel="stylesheet" href="<?php echo Uri::root(); ?>media/plg_system_aiassistant/css/console.css">
</head>
<body>
    <div id="ai-console-app" class="ai-console">
        <!-- Header -->
        <header class="ai-console-header">
            <h1>
                <svg class="ai-icon" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                </svg>
                <?php echo Text::_('PLG_SYSTEM_AIASSISTANT_CONSOLE_TITLE'); ?>
            </h1>
            <div class="ai-console-controls">
                <button id="history-btn" class="btn btn-secondary" title="View session history">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <polyline points="12 6 12 12 16 14"/>
                    </svg>
                    History
                </button>
                <button id="test-api-btn" class="btn btn-secondary" title="Test API configuration">
                    🔧 Test API
                </button>
                <button id="view-logs-btn" class="btn btn-secondary" title="View recent logs">
                    📋 View Logs
                </button>
                <button id="settings-btn" class="btn btn-secondary" title="Configure plugin settings">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="3"/>
                        <path d="M12 1v6m0 6v6M4.22 4.22l4.24 4.24m7.08 7.08l4.24 4.24M1 12h6m6 0h6M4.22 19.78l4.24-4.24m7.08-7.08l4.24-4.24"/>
                    </svg>
                    Settings
                </button>
            </div>
        </header>

        <!-- Main Content -->
        <div class="ai-console-main">
            <!-- Conversation Area -->
            <div class="ai-conversation" id="conversation">
                <div class="ai-welcome">
                    <h2>Welcome to AI Assistant</h2>
                    <p>I can help you manage your Joomla site. Try asking me to:</p>
                    <ul class="ai-suggestions">
                        <li>"Update the homepage hero section to announce our Winter Sale"</li>
                        <li>"Find all unpublished articles about events"</li>
                        <li>"Change the footer contact information"</li>
                        <li>"List all modules in the sidebar-right position"</li>
                        <li>"Create a new article about our latest product"</li>
                    </ul>
                </div>
            </div>

            <!-- Input Area -->
            <div class="ai-input-area">
                <div class="ai-input-wrapper">
                    <textarea 
                        id="prompt-input" 
                        class="ai-input" 
                        placeholder="Ask me to do something with your Joomla site..."
                        rows="3"
                    ></textarea>
                    <div class="ai-input-actions">
                        <label class="ai-checkbox">
                            <input type="checkbox" id="require-review" checked>
                            <span>Review before applying changes</span>
                        </label>
                        <button id="submit-btn" class="btn btn-primary">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <line x1="22" y1="2" x2="11" y2="13"/>
                                <polygon points="22 2 15 22 11 13 2 9 22 2"/>
                            </svg>
                            Send
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- History Sidebar -->
        <div id="history-sidebar" class="ai-sidebar ai-history-sidebar">
            <div class="ai-sidebar-header">
                <h3>Session History</h3>
                <button id="close-history" class="btn-close">&times;</button>
            </div>
            <div class="ai-sidebar-content" id="history-list">
                <div class="ai-loading">Loading history...</div>
            </div>
        </div>

        <!-- Action Review Modal -->
        <div id="review-modal" class="ai-modal">
            <div class="ai-modal-content">
                <div class="ai-modal-header">
                    <h3>Review Actions</h3>
                    <button class="btn-close" id="close-review">&times;</button>
                </div>
                <div class="ai-modal-body" id="review-actions">
                    <!-- Actions will be inserted here -->
                </div>
                <div class="ai-modal-footer">
                    <button id="execute-all-btn" class="btn btn-primary">Execute All</button>
                    <button id="cancel-review-btn" class="btn btn-secondary">Cancel</button>
                </div>
            </div>
        </div>

        <!-- Loading Overlay -->
        <div id="loading-overlay" class="ai-loading-overlay" style="display: none;">
            <div class="ai-spinner"></div>
            <p>AI is thinking...</p>
        </div>
    </div>

    <script>
        // Pass configuration to JavaScript
        window.AI_ASSISTANT_CONFIG = {
            baseUrl: '<?php echo Uri::root(); ?>',
            token: '<?php echo \Joomla\CMS\Session\Session::getFormToken(); ?>'
        };
    </script>
    <script src="<?php echo Uri::root(); ?>media/plg_system_aiassistant/js/console.js"></script>
</body>
</html>

