# Lucky Pup Photography – Albums Website

A sleek, modern dark site with lime green accents for clients to access photo albums using unique codes. Admin can create albums and upload photos, then share codes with clients.

**Now with Google Cloud Run support for scalable, serverless deployment!**

## Features
- 🖼️ Beautiful photo gallery with lightbox view
- 🔐 Age verification gate
- 📱 Responsive design
- 🌐 Unique access codes for albums and groups
- ☁️ Cloud-native: runs locally or on Google Cloud Run
- 💾 Flexible storage: SQLite + local files OR PostgreSQL + Cloud Storage

## Stack
- **Backend**: Node.js + Express
- **Views**: EJS templates
- **Database**: SQLite (local) or PostgreSQL (Cloud SQL)
- **Storage**: Local filesystem or Google Cloud Storage
- **Image Processing**: Sharp
- **Styling**: SCSS compiled to CSS

## Quick Start - Local Development

The easiest way to get started:

```bash
# Run the setup script
chmod +x setup-local-dev.sh
./setup-local-dev.sh

# Start the server
npm run dev
```

Or manually:

1) **Install dependencies**
```bash
npm install
```

2) **Create environment file**
```bash
cp .env.example .env
# Edit .env and set ADMIN_PASSWORD
```

3) **Build CSS and run**
```bash
npm run build:css
npm run dev
# or: npm start
```

4) **Open the site**
- Public: `http://localhost:3000/`
- Admin: `http://localhost:3000/admin`
  - Username: `admin`
  - Password: from `.env` (`ADMIN_PASSWORD`)

## Admin Workflow
1. Visit `/admin` and create a new album by title.
2. You’ll be redirected to the album page with the generated code (e.g. `9KX2T7QJ`).
3. Upload images to that album.
4. Share the link `http://localhost:3000/a/CODE` or just the code with your client.

## Folders
- `src/` – server and database
- `views/` – EJS templates
- `public/scss/custom.scss` – source styles (dark theme + lime accent)
- `public/css/custom.css` – compiled CSS
- `uploads/` – photos saved per album id (auto-created)
- `data/db.sqlite` – SQLite database (auto-created)

## Notes
- Basic Auth is used for admin. Change `ADMIN_PASSWORD` in `.env`.
- Only image uploads are accepted.
- Unique album codes are generated automatically and are case-insensitive for access.

## Scripts
- `npm run build:css` – compile SCSS to CSS
- `npm run watch:css` – watch and rebuild CSS on changes
- `npm run dev` – start server with autoreload
- `npm start` – start server

## License
MIT
