# Lucky Pup Photography – Albums Website

A sleek, modern dark site with lime green accents for clients to access photo albums using unique codes. Admin can create albums and upload photos, then share codes with clients.

## Stack
- Node.js + Express
- EJS views
- SQLite (better-sqlite3)
- Multer for uploads
- SCSS compiled to CSS

## Quick Start

1) Install dependencies
```bash
npm install
```

2) Create environment file
```bash
copy .env.example .env
# then edit .env to set ADMIN_PASSWORD
```

3) Build CSS (one-time) and run
```bash
npm run build:css
npm run dev
# or: npm start
```

4) Open the site
- Public: `http://localhost:3000/`
- Admin: `http://localhost:3000/admin`
  - Username: `admin`
  - Password: from `.env` (`ADMIN_PASSWORD`)

## Admin Workflow
1. Visit `/admin` and create a new album by title.
2. You’ll be redirected to the album page with the generated code (e.g. `9KX2T7QJ`).
3. Upload images to that album.
4. Share the link `http://localhost:3000/a/CODE` or just the code with your client.

## Folders
- `src/` – server and database
- `views/` – EJS templates
- `public/scss/custom.scss` – source styles (dark theme + lime accent)
- `public/css/custom.css` – compiled CSS
- `uploads/` – photos saved per album id (auto-created)
- `data/db.sqlite` – SQLite database (auto-created)

## Notes
- Basic Auth is used for admin. Change `ADMIN_PASSWORD` in `.env`.
- Only image uploads are accepted.
- Unique album codes are generated automatically and are case-insensitive for access.

## Scripts
- `npm run build:css` – compile SCSS to CSS
- `npm run watch:css` – watch and rebuild CSS on changes
- `npm run dev` – start server with autoreload
- `npm start` – start server

## License
MIT
