# Lucky Pup Photography – Albums Website

A sleek, modern dark site with lime green accents for clients to access photo albums using unique codes. Admin can create albums and upload photos, then share codes with clients.

**Now with Google Cloud Run support for scalable, serverless deployment!**

## Features
- 🖼️ Beautiful photo gallery with lightbox view
- 🔐 Age verification gate
- 📱 Responsive design
- 🌐 Unique access codes for albums and groups
- ☁️ Cloud-native: runs locally or on Google Cloud Run
- 💾 Flexible storage: SQLite + local files OR PostgreSQL + Cloud Storage

## Stack
- **Backend**: Node.js + Express
- **Views**: EJS templates
- **Database**: SQLite (local) or PostgreSQL (Cloud SQL)
- **Storage**: Local filesystem or Google Cloud Storage
- **Image Processing**: Sharp
- **Styling**: SCSS compiled to CSS

## Quick Start - Local Development

The easiest way to get started:

```bash
# Run the setup script
chmod +x setup-local-dev.sh
./setup-local-dev.sh

# Start the server
npm run dev
```

Or manually:

1) **Install dependencies**
```bash
npm install
```

2) **Create environment file**
```bash
cp .env.example .env
# Edit .env and set ADMIN_PASSWORD
```

3) **Build CSS and run**
```bash
npm run build:css
npm run dev
# or: npm start
```

4) **Open the site**
- Public: `http://localhost:3000/`
- Admin: `http://localhost:3000/admin`
  - Username: `admin`
  - Password: from `.env` (`ADMIN_PASSWORD`)

## Admin Workflow
1. Visit `/admin` and create a new album by title
2. You'll be redirected to the album page with the generated code (e.g. `9KX2T7QJ`)
3. Upload images to that album
4. Share the link or just the code with your client
5. Optionally create album groups to organize multiple albums

## Folders
- `src/` – server and database
- `views/` – EJS templates
- `public/scss/custom.scss` – source styles (dark theme + lime accent)
- `public/css/custom.css` – compiled CSS
- `uploads/` – photos saved per album id (auto-created)
- `data/db.sqlite` – SQLite database (auto-created)

## Deployment to Google Cloud Run

Deploy this application to Google Cloud for production use:

### Option 1: Automated Script

```bash
chmod +x deploy.sh
./deploy.sh
```

### Option 2: Manual Deployment

See the comprehensive **[DEPLOYMENT.md](./DEPLOYMENT.md)** guide for detailed instructions.

### What You Get with Cloud Run

- ☁️ **Serverless**: Pay only for what you use
- 🚀 **Scalable**: Automatically scales from 0 to thousands of instances
- 💪 **Reliable**: Built on Google's infrastructure
- 🔒 **Secure**: HTTPS by default, Secret Manager for credentials
- 💾 **Persistent**: PostgreSQL database and Cloud Storage for images
- 💰 **Affordable**: Free tier covers light usage (~$10-30/month for moderate use)

## Environment Variables

The application supports two modes:

### Local Development (Default)
```env
USE_POSTGRES=false
USE_CLOUD_STORAGE=false
ADMIN_PASSWORD=changeme
PORT=3000
```

### Cloud Production
```env
USE_POSTGRES=true
USE_CLOUD_STORAGE=true
GCS_BUCKET_NAME=your-bucket-name
DB_NAME=photowebsite
INSTANCE_UNIX_SOCKET=/cloudsql/project:region:instance
ADMIN_PASSWORD=secure-password (stored in Secret Manager)
PORT=8080
```

See `.env.example` for all available options.

## Notes
- Basic Auth is used for admin. Change `ADMIN_PASSWORD` in `.env`
- Only image uploads are accepted (jpg, png, gif, webp)
- Unique album codes are generated automatically (8 characters, A-Z, 2-9)
- Codes are case-insensitive for access
- Age verification required (18+)

## Scripts
- `npm run build:css` – compile SCSS to CSS
- `npm run watch:css` – watch and rebuild CSS on changes
- `npm run dev` – start server with autoreload (nodemon)
- `npm start` – start server in production mode
- `npm run generate-thumbs` – regenerate all thumbnails

## Project Structure
```
PhotoWebsite/
├── src/
│   ├── server.js           # Express server and routes
│   ├── db.js               # Database abstraction layer
│   ├── db-postgres.js      # PostgreSQL implementation
│   ├── storage.js          # Cloud Storage abstraction
│   └── generate-thumbnails.js
├── views/                  # EJS templates
│   ├── admin/              # Admin pages
│   └── [public pages]
├── public/                 # Static assets
│   ├── css/
│   ├── js/
│   ├── scss/
│   └── fonts/
├── uploads/                # Local file uploads (dev only)
├── data/                   # SQLite database (dev only)
├── Dockerfile              # Container definition
├── cloudbuild.yaml         # Cloud Build configuration
├── deploy.sh               # Deployment automation
└── DEPLOYMENT.md           # Detailed deployment guide
```

## Architecture

### Local Development
```
Browser → Express Server → SQLite + Local Files
```

### Cloud Production
```
Browser → Cloud Run → Cloud SQL (PostgreSQL)
                   → Cloud Storage (Images)
                   → Secret Manager (Credentials)
```

## Troubleshooting

### Local Development
- **"Port 3000 already in use"**: Change `PORT` in `.env`
- **"Database locked"**: SQLite WAL mode handles this, but restart if needed
- **CSS not updating**: Run `npm run build:css`

### Cloud Deployment
- See [DEPLOYMENT.md](./DEPLOYMENT.md) for detailed troubleshooting
- Check logs: `gcloud run services logs read photowebsite --region=us-central1`

## Contributing

This is a personal project, but feel free to fork and adapt for your needs.

## License
MIT
