<?php
/**
 * Temporary script to clear PHP OPcache
 * DELETE THIS FILE AFTER USE
 */

// Check if we're logged in as admin
define('_JEXEC', 1);
define('JPATH_BASE', __DIR__);

require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';

$app = Joomla\CMS\Factory::getApplication('site');
$user = $app->getIdentity();

if (!$user || !$user->authorise('core.admin')) {
    die('Unauthorized');
}

// Clear OPcache
if (function_exists('opcache_reset')) {
    opcache_reset();
    echo "✓ OPcache cleared successfully!<br>";
} else {
    echo "✗ OPcache is not enabled<br>";
}

// Clear Joomla cache
$cache = Joomla\CMS\Factory::getCache();
$cache->clean();
echo "✓ Joomla cache cleared<br>";

echo "<br><strong>Now try the AI Assistant again.</strong><br>";
echo "<br><em>Remember to delete this file after use!</em>";

