<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.aiassistant
 *
 * @copyright   Copyright (C) 2025 Open Source Matters. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

namespace Joomla\Plugin\System\AiAssistant\AI;

defined('_JEXEC') or die;

/**
 * Interface for AI providers
 *
 * @since  1.0.0
 */
interface AIProviderInterface
{
    /**
     * Send a chat message and get response
     *
     * @param   array  $messages  Conversation history
     *
     * @return  string  AI response
     * @since   1.0.0
     */
    public function chat(array $messages): string;

    /**
     * Get provider name
     *
     * @return  string
     * @since   1.0.0
     */
    public function getName(): string;

    /**
     * Validate API credentials
     *
     * @return  boolean
     * @since   1.0.0
     */
    public function validateCredentials(): bool;
}

