(function(){
  function ready(fn){ if(document.readyState!=='loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }

  ready(function(){
    const gallery = document.querySelector('.gallery');
    if (!gallery) return;

    const items = Array.from(gallery.querySelectorAll('.gallery a'));
    const targetRowHeight = 350; // Target height for rows
    const containerPadding = 4; // Account for padding

    function layoutJustified(){
      const containerWidth = gallery.offsetWidth - containerPadding;
      let currentRow = [];
      let currentRowWidth = 0;
      let top = 0;

      items.forEach(function(item, index){
        const img = item.querySelector('img');
        if (!img || !img.naturalWidth) return;

        const aspectRatio = img.naturalWidth / img.naturalHeight;
        const scaledWidth = targetRowHeight * aspectRatio;

        currentRow.push({ item: item, width: scaledWidth, aspectRatio: aspectRatio });
        currentRowWidth += scaledWidth;

        const isLastItem = index === items.length - 1;
        const rowIsFull = currentRowWidth >= containerWidth * 0.95;

        if (rowIsFull || isLastItem) {
          // Calculate actual row height to fit container width
          const rowHeight = isLastItem && !rowIsFull 
            ? targetRowHeight 
            : (containerWidth / currentRowWidth) * targetRowHeight;
          
          let left = 0;
          currentRow.forEach(function(obj){
            const itemWidth = obj.aspectRatio * rowHeight;
            obj.item.style.position = 'absolute';
            obj.item.style.top = top + 'px';
            obj.item.style.left = left + 'px';
            obj.item.style.width = itemWidth + 'px';
            obj.item.style.height = rowHeight + 'px';
            left += itemWidth + 2; // 2px gap
          });

          top += rowHeight + 2; // 2px gap
          currentRow = [];
          currentRowWidth = 0;
        }
      });

      // Set gallery height
      gallery.style.height = top + 'px';
      gallery.style.position = 'relative';
    }

    // Wait for all images to load
    let loadedCount = 0;
    const images = gallery.querySelectorAll('img');
    
    images.forEach(function(img){
      if (img.complete && img.naturalWidth) {
        loadedCount++;
      } else {
        img.addEventListener('load', function(){
          loadedCount++;
          if (loadedCount === images.length) {
            layoutJustified();
          }
        });
      }
    });

    if (loadedCount === images.length) {
      layoutJustified();
    }

    let resizeTimer;
    window.addEventListener('resize', function(){
      clearTimeout(resizeTimer);
      resizeTimer = setTimeout(layoutJustified, 150);
    });
  });
})();

