# AI Assistant - Installation Guide

Complete step-by-step installation instructions for the AI Assistant plugin.

## Prerequisites

Before you begin, ensure you have:

- ✅ Joomla 5.0 or higher
- ✅ PHP 8.2 or higher
- ✅ MySQL 5.7+ or MariaDB 10.3+
- ✅ Super User access to Joomla admin
- ✅ OpenAI API key OR Anthropic API key

## Step 1: Obtain an API Key

### Option A: OpenAI (Recommended for beginners)

1. Go to https://platform.openai.com/
2. Sign up or log in
3. Navigate to API Keys section
4. Click "Create new secret key"
5. **Important**: Copy the key immediately (you won't see it again)
6. Save it securely

**Pricing**: Pay-as-you-go, typically $0.01-0.03 per request
**Models**: GPT-4o (best), GPT-4o Mini (fast/cheap), GPT-4 Turbo

### Option B: Anthropic Claude

1. Go to https://console.anthropic.com/
2. Sign up or log in
3. Navigate to API Keys
4. Create a new key
5. Copy and save securely

**Pricing**: Similar to OpenAI, competitive rates
**Models**: Claude 3.5 Sonnet (best), Claude 3.5 Haiku (fast), Claude 3 Opus (most capable)

## Step 2: Download the Plugin

### From Repository

```bash
git clone https://github.com/yourorg/joomla-ai-assistant.git
cd joomla-ai-assistant
```

### Create Installation Package

```bash
cd plugins/system/aiassistant
zip -r aiassistant.zip .
```

The zip should contain:
```
aiassistant/
├── aiassistant.xml
├── services/
├── src/
├── tmpl/
├── media/
├── language/
└── README.md
```

## Step 3: Install via Joomla

1. Log into your Joomla administrator
2. Go to **System → Extensions → Install**
3. Click **Upload Package File**
4. Select `aiassistant.zip`
5. Click **Upload & Install**

You should see:
```
✓ Installation of the plugin was successful.
```

## Step 4: Enable the Plugin

1. Go to **System → Plugins**
2. Search for "AI Assistant"
3. Click on the plugin name
4. Set **Status** to **Enabled**
5. Don't configure yet - save first

## Step 5: Configure the Plugin

### Basic Configuration

1. In the plugin settings, configure:

**AI Provider Settings:**
```
AI Provider: [Select OpenAI or Anthropic]
```

**If using OpenAI:**
```
OpenAI API Key: [Paste your key]
OpenAI Model: GPT-4o (recommended)
```

**If using Anthropic:**
```
Anthropic API Key: [Paste your key]
Anthropic Model: Claude 3.5 Sonnet (recommended)
```

### Safety Settings (Important!)

```
Require Review: Yes (recommended for production)
Max Actions Per Request: 10 (start conservative)
Log All Actions: Yes (recommended)
```

### Permissions

Enable the actions you want the AI to perform:

**For Read-Only Testing (Safest):**
- ✅ Read Articles
- ✅ Read Modules
- ✅ Read Menus
- ✅ Read SP Page Builder
- ✅ Read Templates
- ✅ Read Configuration

**For Full Functionality:**
- ✅ All of the above, plus:
- ✅ Write/Update Articles
- ✅ Write/Update Modules
- ✅ Write/Update Menus
- ✅ Write/Update SP Page Builder

**Recommended for First-Time Use:** Start with read-only, test, then enable write permissions.

2. Click **Save & Close**

## Step 6: Verify Installation

### Database Tables

Check that the tables were created:

1. Go to phpMyAdmin or your database tool
2. Look for these tables:
   - `jos_aiassistant_sessions`
   - `jos_aiassistant_actions`

If they don't exist, they'll be created automatically on first use.

### Test API Connection

1. Access the console (see Step 7)
2. Try a simple read command:
   ```
   Get information about this Joomla site
   ```
3. You should get a response with site details

## Step 7: Access the Console

### Direct URL Method

Navigate to:
```
https://yoursite.com/administrator/index.php?option=com_ajax&plugin=aiassistant&group=system&format=raw
```

Replace `yoursite.com` with your actual domain.

**Bookmark this URL for easy access!**

### Create Admin Menu Link (Optional)

1. Go to **Menus → Administrator → All Menu Items**
2. Click **New**
3. Title: `AI Assistant`
4. Menu Item Type: External URL
5. Link: The URL from above
6. Target Window: Parent
7. **Save & Close**

Now you'll see "AI Assistant" in your admin menu.

## Step 8: Test with Safe Commands

Start with these safe, read-only commands:

```
Show me basic information about this site
```

```
List all published articles
```

```
Find all modules in the sidebar position
```

```
What Joomla version am I running?
```

If these work, your installation is successful!

## Step 9: Enable Write Operations (When Ready)

Once you're comfortable:

1. Take a **full backup** of your site
2. Go back to plugin settings
3. Enable write permissions:
   - ✅ Write/Update Articles
   - ✅ Write/Update Modules
   - etc.
4. Keep **Require Review** enabled
5. Test with a non-critical update:
   ```
   Create a test article called "AI Test" in the uncategorized category, 
   set it to unpublished
   ```
6. Review the planned actions
7. Execute if everything looks correct
8. Verify the article was created

## Troubleshooting Installation

### Plugin Won't Install

**Error**: "Installation failed"

**Solutions**:
- Check that you zipped the plugin folder correctly
- Verify all files are present
- Check PHP memory limit (increase if needed)
- Review Joomla error logs

### Plugin Installs But Won't Enable

**Error**: Various PHP errors

**Solutions**:
- Verify PHP version is 8.2+
- Check for missing PHP extensions
- Review server error logs
- Ensure proper file permissions

### Console Shows "Unauthorized"

**Solutions**:
- Ensure you're logged in as Super User
- Check that plugin is enabled
- Clear Joomla cache
- Check browser console for errors

### API Key Errors

**Error**: "Invalid API key" or "Authentication failed"

**Solutions**:
- Verify you copied the entire key
- Check for extra spaces
- Ensure billing is set up on API provider
- Try regenerating the key

### Database Table Issues

**Error**: Tables not created

**Solutions**:
```sql
-- Manually create tables if needed:

CREATE TABLE IF NOT EXISTS `jos_aiassistant_sessions` (
  `id` VARCHAR(50) NOT NULL,
  `user_id` INT NOT NULL,
  `prompt` TEXT NOT NULL,
  `status` VARCHAR(50) NOT NULL,
  `result` MEDIUMTEXT NULL,
  `started_at` DATETIME NOT NULL,
  `ended_at` DATETIME NULL,
  PRIMARY KEY (`id`),
  INDEX `idx_user_started` (`user_id`, `started_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `jos_aiassistant_actions` (
  `id` INT AUTO_INCREMENT,
  `session_id` VARCHAR(50) NOT NULL,
  `action_type` VARCHAR(100) NOT NULL,
  `parameters` TEXT NULL,
  `result` TEXT NULL,
  `status` VARCHAR(50) NOT NULL,
  `error` TEXT NULL,
  `executed_at` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `idx_session` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
```

### Console Loads But AI Doesn't Respond

**Solutions**:
- Check browser Network tab for failed requests
- Verify API key is configured
- Check that your API account has credit/quota
- Review PHP error logs
- Ensure server can make external HTTPS requests

## Uninstallation

To remove the plugin:

1. **Backup** your site first
2. Go to **System → Extensions → Manage**
3. Search for "AI Assistant"
4. Select the plugin
5. Click **Uninstall**

**Note**: Database tables will remain. To remove them:

```sql
DROP TABLE IF EXISTS `jos_aiassistant_sessions`;
DROP TABLE IF EXISTS `jos_aiassistant_actions`;
```

## Security Checklist

After installation:

- ✅ API key is stored securely in plugin config
- ✅ Only Super Users can access the console
- ✅ "Require Review" is enabled
- ✅ Action logging is enabled
- ✅ Limited permissions set initially
- ✅ Backup system is in place
- ✅ Tested in development before production

## Next Steps

1. **Read the Documentation**
   - Review README.md for features
   - Check EXAMPLES.md for usage patterns

2. **Start Simple**
   - Use read-only commands first
   - Get familiar with the interface
   - Understand how the AI responds

3. **Gradually Increase Permissions**
   - Add write permissions one at a time
   - Test each new capability
   - Monitor the action logs

4. **Integrate into Workflow**
   - Bookmark the console
   - Train team members
   - Establish usage guidelines

## Support

If you encounter issues:

1. Check the troubleshooting section above
2. Review Joomla error logs
3. Check browser console for JavaScript errors
4. Verify API provider status
5. Open an issue on GitHub with details

## Updates

To update the plugin:

1. Download new version
2. Install over existing (Joomla handles update)
3. Clear cache
4. Test functionality

Configuration and data are preserved during updates.

---

**Congratulations!** You've successfully installed the AI Assistant plugin. Start with simple commands and gradually explore its capabilities.

