# Changelog - AI Assistant Plugin

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.1] - 2025-10-24

### Security
- **[CRITICAL]** Added CSRF token validation for all AJAX requests
- **[HIGH]** Fixed XSS vulnerabilities in console.js by using DOM APIs instead of innerHTML
- **[HIGH]** Removed sensitive error traces from public API responses
- **[HIGH]** Fixed API error messages to prevent information disclosure
- **[MEDIUM]** Implemented rate limiting to prevent abuse (configurable in plugin settings)
- **[MEDIUM]** Added comprehensive input validation and sanitization
- **[MEDIUM]** Added API key validation before making requests
- **[LOW]** Fixed database collation consistency across all tables

### Fixed
- **[HIGH]** Fixed admin URL construction in console.js that prevented connection on most installations
- **[MEDIUM]** Fixed memory leak by implementing conversation history size limits
- **[MEDIUM]** Removed unused ConsoleController.php to clean up codebase
- **[LOW]** Improved JSON parsing regex for better reliability
- **[LOW]** Added JSON error checking after all decode operations
- **[LOW]** Added parameter key sanitization in action processing
- **[LOW]** Added JSON_UNESCAPED_UNICODE flag for proper character encoding

### Added
- Rate limiting configuration options in plugin settings
- Automatic conversation history trimming (max 50 messages)
- Comprehensive error logging for debugging
- Input validation with maximum prompt length (10,000 characters)
- Security documentation (SECURITY_FIXES.md)

### Changed
- Error messages now use generic text instead of exposing internal details
- All error details are logged internally for administrator review
- JSON responses include proper Unicode handling

### Configuration
New plugin settings added:
- **Rate Limit - Max Requests**: Maximum requests per user per time window (default: 10)
- **Rate Limit - Time Window**: Time window in seconds for rate limiting (default: 60)

## [1.0.0] - 2025-10-01

### Added
- Initial release
- Support for OpenAI (GPT-4o, GPT-4o Mini, GPT-4 Turbo)
- Support for Anthropic (Claude 3.5 Sonnet, Claude 3.5 Haiku, Claude 3 Opus)
- Agentic AI system with multi-step reasoning
- Review mode for action approval
- Action logging and audit trail
- Console UI for natural language commands
- 10+ built-in actions for articles, modules, menus, and SP Page Builder
- Permission-based action control
- Session history tracking

### Actions Available
- read_article - Get full article data by ID
- search_articles - Search articles by keyword, category, or status
- create_article - Create new articles
- update_article - Modify existing articles
- read_module - Get module data and parameters
- list_modules - List modules by position or type
- update_module - Modify module content and parameters
- read_menu - Get menu structure and items
- read_pagebuilder_page - Get SP Page Builder page content
- update_pagebuilder_page - Update SP Page Builder content
- get_site_info - Get general site information

---

## Upgrade Notes

### From 1.0.0 to 1.0.1
This is a security and bug fix release. **Upgrade is highly recommended.**

- No database migrations required
- No breaking changes to existing functionality
- Existing configurations remain valid
- New rate limiting features use sensible defaults
- Review new security settings in plugin configuration

### Testing After Upgrade
1. Clear Joomla cache
2. Test console access
3. Verify CSRF protection is working
4. Review and configure rate limiting settings
5. Test your most common AI commands

---

## Support

For issues, questions, or feature requests:
- Review SECURITY_FIXES.md for detailed security information
- Check ARCHITECTURE.md for technical details
- Review EXAMPLES.md for usage examples
- Consult Joomla community forums

---

## License

GNU General Public License version 2 or later
Copyright (C) 2025 Open Source Matters. All rights reserved.

