# Changelog

All notable changes to this project will be documented in this file.

## [v31] - 2025-10-10

### Added - GitHub Actions Automation
- **Automated deployment workflow** via GitHub Actions
  - Triggers automatically on push to `main` branch
  - Builds Docker image via Google Cloud Build
  - Deploys to Cloud Run without manual intervention
- **Service account setup** for secure GitHub Actions authentication
  - Created dedicated `github-actions` service account
  - Configured with necessary GCP permissions (Cloud Run Admin, Cloud Build Editor, Storage Admin)
- **Workflow file** at `.github/workflows/deploy.yml`
  - Uses short commit SHA for version tracking
  - Provides deployment summary with URLs
  - Secure authentication via GitHub secrets
- **Updated documentation** in `GITHUB_SETUP.md` with setup instructions
- **Enhanced `.gitignore`** to prevent accidental service account key commits

### Changed
- Updated `GITHUB_SETUP.md` with GitHub Actions setup instructions
- Replaced Cloud Build triggers section with GitHub Actions workflow guide

## [v30] - 2025-10-10

### Added - Multi-Site Configuration
- **Environment variable configuration** for multi-site deployments
  - `AGE_VERIFICATION_ENABLED`: Toggle 18+ age gate on/off
  - `PRIMARY_COLOR`: Customizable brand color (hex)
  - `LOGO_URL`: Configurable logo path or URL
  - `SITE_NAME`: Customizable site name/branding
- **Dynamic site configuration** passed to all EJS templates via `res.locals.siteConfig`
- **CSS variable injection** for primary color in page head
- **Comprehensive deployment guides**:
  - `DEPLOYMENT.md` - Multi-site deployment guide
  - `GITHUB_SETUP.md` - GitHub setup and workflow
  - `README.md` - Updated with multi-site features
  - `CHANGELOG.md` - This file

### Changed
- Age verification middleware now respects `AGE_VERIFICATION_ENABLED` env var
- All view templates updated to use `siteConfig` for branding
- `cloudbuild.yaml` updated with substitution variables for site config
- Logo and site name now dynamically rendered in all views
- Favicon now uses dynamic primary color

### Technical Details
- Server.js now loads site config from environment variables
- Added middleware to inject `siteConfig` into all views:
  ```javascript
  res.locals.siteConfig = {
    primaryColor: PRIMARY_COLOR,
    logoUrl: LOGO_URL,
    siteName: SITE_NAME,
    ageVerificationEnabled: AGE_VERIFICATION_ENABLED
  };
  ```

## [v29] - 2025-10-10

### Fixed - Album Reordering
- Completely rewrote album drag-and-drop system
- Fixed backend ordering logic to properly resequence albums
- Removed complex normalization in favor of simple sequential sort orders

## [v22-v28] - 2025-10-10

### Fixed - Photo and Album Ordering
- Multiple iterations fixing drag-and-drop for photos and albums
- Fixed cache invalidation issues causing stale data
- Added `reloadData()` function to force cache refresh
- Fixed `listAlbums()` to sort by `sort_order` instead of `created_at`
- Improved drag-and-drop UI with better position detection
- Added extensive logging for debugging order changes

## [Previous Versions]

See git history for earlier changes including:
- Initial Cloud Run migration
- JSON database implementation
- Cloud Storage integration
- Photo upload and management features
- Admin panel development

