# Quick Start Guide

## Choose Your Path

### 🏠 Local Development (Recommended for Testing)

```bash
# 1. Clone/navigate to project
cd PhotoWebsite

# 2. Run setup script
chmod +x setup-local-dev.sh
./setup-local-dev.sh

# 3. Update .env file with your admin password
nano .env  # or use your favorite editor

# 4. Start the server
npm run dev

# 5. Open browser
# Public: http://localhost:3000
# Admin:  http://localhost:3000/admin
```

That's it! Your local development environment is ready.

---

### ☁️ Cloud Run Deployment (Production)

**Prerequisites:**
- GCP account with billing enabled
- gcloud CLI installed and configured

```bash
# 1. Set your GCP project
gcloud config set project YOUR_PROJECT_ID

# 2. Run deployment script
chmod +x deploy.sh
./deploy.sh

# 3. Follow the prompts
# The script will:
#   - Enable required APIs
#   - Create Cloud SQL instance
#   - Create Cloud Storage bucket
#   - Set up secrets
#   - Build and deploy your app
```

**That's it!** Your app will be live on Cloud Run with a URL like:
`https://photowebsite-xxxxx-uc.a.run.app`

---

## What's Different?

| Feature | Local Dev | Cloud Run |
|---------|-----------|-----------|
| **Database** | SQLite (file) | Cloud SQL (PostgreSQL) |
| **Storage** | Local filesystem | Cloud Storage |
| **URL** | localhost:3000 | yourapp.run.app |
| **Cost** | Free | ~$10-30/month |
| **Scalability** | Single machine | Auto-scales |
| **HTTPS** | No | Yes (automatic) |

---

## Common Tasks

### Add an Album (Local or Cloud)
1. Go to `/admin`
2. Login with username `admin` and your password
3. Click "Create New Album"
4. Enter album title
5. Upload photos
6. Share the generated code with your client

### View Logs (Cloud Only)
```bash
gcloud run services logs read photowebsite --region=us-central1 --follow
```

### Update Cloud Deployment
```bash
# After making code changes:
gcloud builds submit --config=cloudbuild.yaml
```

### Change Admin Password (Cloud)
```bash
# Update secret
echo -n "NEW_PASSWORD" | gcloud secrets versions add photowebsite-admin-password --data-file=-

# Redeploy (Cloud Run will automatically pick up new secret)
```

---

## Need Help?

- **Local Development**: See [README.md](./README.md)
- **Cloud Deployment**: See [DEPLOYMENT.md](./DEPLOYMENT.md)
- **Troubleshooting**: Check the troubleshooting section in DEPLOYMENT.md

---

## Architecture at a Glance

```
┌─────────────────────────────────────────────┐
│                   Browser                   │
└──────────────┬──────────────────────────────┘
               │
        ┌──────▼───────┐
        │   Cloud Run  │
        │  (Container) │
        └──┬────┬────┬─┘
           │    │    │
     ┌─────▼┐  │  ┌─▼──────────┐
     │ Cloud│  │  │   Cloud    │
     │  SQL │  │  │  Storage   │
     │ (DB) │  │  │  (Images)  │
     └──────┘  │  └────────────┘
               │
          ┌────▼──────┐
          │  Secret   │
          │  Manager  │
          │(Passwords)│
          └───────────┘
```

---

## Cost Estimates

### Minimal Setup (Development/Testing)
- Cloud Run: **Free** (within free tier)
- Cloud SQL (f1-micro): **$10/month**
- Cloud Storage: **$1/month**
- **Total: ~$11/month**

### Production (Moderate Traffic)
- Cloud Run: **$10-30/month**
- Cloud SQL (g1-small): **$25/month**
- Cloud Storage: **$3-10/month**
- **Total: ~$38-65/month**

Cloud Run free tier includes:
- 2 million requests/month
- 360,000 GB-seconds memory
- 180,000 vCPU-seconds

Most small to medium sites stay within free tier for Cloud Run!

