<?php
// Simple test to check if the AI plugin is working
// Place this in your Joomla root directory and access it via browser

define('_JEXEC', 1);
define('JPATH_BASE', __DIR__);

require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';

use Joomla\CMS\Factory;
use Joomla\CMS\Log\Log;

// Get the application
$app = Factory::getApplication('site');

// Add logger
Log::addLogger(
    ['text_file' => 'test_ai.php'],
    Log::ALL,
    ['test_ai']
);

echo "<h1>AI Assistant Plugin Test</h1>";

// Check if plugin is enabled
$db = Factory::getDbo();
$query = $db->getQuery(true)
    ->select('*')
    ->from($db->quoteName('#__extensions'))
    ->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
    ->where($db->quoteName('folder') . ' = ' . $db->quote('system'))
    ->where($db->quoteName('element') . ' = ' . $db->quote('aiassistant'));

$db->setQuery($query);
$plugin = $db->loadObject();

echo "<h2>Plugin Status:</h2>";
if ($plugin) {
    echo "<p><strong>Enabled:</strong> " . ($plugin->enabled ? 'Yes' : 'No') . "</p>";
    echo "<p><strong>Extension ID:</strong> " . $plugin->extension_id . "</p>";
    echo "<pre>" . print_r($plugin, true) . "</pre>";
} else {
    echo "<p>Plugin not found!</p>";
}

// Test if we can instantiate the orchestrator
try {
    echo "<h2>Testing AI Components:</h2>";
    
    // Try to get the plugin
    $dispatcher = $app->getDispatcher();
    echo "<p>✓ Dispatcher loaded</p>";
    
    // Check if OpenAI API key is configured
    $params = json_decode($plugin->params, true);
    $apiKey = $params['api_key'] ?? '';
    
    if (empty($apiKey)) {
        echo "<p>❌ OpenAI API key not configured</p>";
    } else {
        echo "<p>✓ OpenAI API key is configured (length: " . strlen($apiKey) . ")</p>";
    }
    
    echo "<p>✓ Test completed successfully</p>";
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h2>Recent Logs:</h2>";
$logFile = JPATH_ROOT . '/administrator/logs/aiassistant.php';
if (file_exists($logFile)) {
    $logs = file($logFile);
    $recentLogs = array_slice($logs, -50);
    echo "<pre style='background: #f5f5f5; padding: 10px; max-height: 400px; overflow: auto;'>";
    echo htmlspecialchars(implode('', $recentLogs));
    echo "</pre>";
} else {
    echo "<p>No log file found at: $logFile</p>";
}

