# Multi-Site Configuration - Complete ✅

Your photo website platform is now fully configured for multi-site deployments!

## What Changed (v31)

### 🎨 Configurable Branding
- **Primary Color**: Change the brand color (currently lime green `#a6ff00`)
- **Logo**: Use any logo URL or path
- **Site Name**: Custom site name for each deployment
- **Age Gate**: Enable/disable 18+ verification per site

### 🚀 Current Deployment

**Site**: https://photowebsite-mrri66ie4q-ew.a.run.app
**Configuration**:
```
AGE_VERIFICATION_ENABLED=true
PRIMARY_COLOR=#a6ff00
LOGO_URL=/nrw-web.png
SITE_NAME=NRW Web
```

## How to Use Multi-Site Features

### Option 1: Update Current Site Configuration

Change settings without redeploying code:

```bash
gcloud run services update photowebsite \
  --update-env-vars="PRIMARY_COLOR=#ff6b00,SITE_NAME=New Site Name,AGE_VERIFICATION_ENABLED=false" \
  --region europe-west1 \
  --project=luckypupphotography
```

### Option 2: Deploy Additional Sites

Deploy a second site with different branding:

```bash
# Create new bucket for site 2
gsutil mb -l europe-west1 gs://luckypupphotography-site2
gsutil iam ch allUsers:objectViewer gs://luckypupphotography-site2

# Deploy site 2
gcloud run deploy photowebsite-site2 \
  --source . \
  --platform managed \
  --region europe-west1 \
  --allow-unauthenticated \
  --set-env-vars="USE_JSON=true,USE_CLOUD_STORAGE=true,GCS_BUCKET_NAME=luckypupphotography-site2" \
  --set-env-vars="AGE_VERIFICATION_ENABLED=false,PRIMARY_COLOR=#3366ff,LOGO_URL=/logo-site2.png,SITE_NAME=Portrait Studio" \
  --set-secrets="ADMIN_PASSWORD=photowebsite-admin-password:latest" \
  --project=luckypupphotography
```

### Option 3: GitHub-Based Deployment

1. **Initialize Git Repository**
   ```bash
   git init
   git add .
   git commit -m "Initial commit - multi-site photo platform"
   ```

2. **Push to GitHub**
   ```bash
   git remote add origin https://github.com/YOUR_USERNAME/photowebsite.git
   git branch -M main
   git push -u origin main
   ```

3. **Deploy from GitHub**
   ```bash
   # Clone on any machine and deploy
   git clone https://github.com/YOUR_USERNAME/photowebsite.git
   cd photowebsite
   
   gcloud run deploy photowebsite-newsite \
     --source . \
     --set-env-vars="SITE_NAME=New Site,PRIMARY_COLOR=#ff99cc" \
     --region europe-west1 \
     --project=your-project
   ```

4. **Update All Sites**
   ```bash
   # Make changes, commit, push
   git add .
   git commit -m "Feature update"
   git push
   
   # Pull and redeploy on any machine
   git pull
   gcloud run deploy photowebsite-site1 --source . --region europe-west1
   gcloud run deploy photowebsite-site2 --source . --region europe-west1
   ```

## Configuration Reference

### Environment Variables

| Variable | Example | Description |
|----------|---------|-------------|
| `AGE_VERIFICATION_ENABLED` | `true` | Show/hide 18+ age gate |
| `PRIMARY_COLOR` | `#ff6b00` | Brand color (hex) |
| `LOGO_URL` | `/nrw-web.png` | Logo path or URL |
| `SITE_NAME` | `My Gallery` | Site name/branding |

### Color Examples

```bash
# Orange
PRIMARY_COLOR=#ff6b00

# Blue
PRIMARY_COLOR=#3366ff

# Pink
PRIMARY_COLOR=#ff99cc

# Purple
PRIMARY_COLOR=#9966ff

# Green (default)
PRIMARY_COLOR=#a6ff00
```

### Logo Options

**Option 1: Use logo in repo**
```bash
# Add logo to public directory
cp /path/to/logo.png public/nrw-web.png
git add public/logo-site2.png
git commit -m "Add logo for site 2"

# Set in deployment
--set-env-vars="LOGO_URL=/logo-site2.png"
```

**Option 2: Use logo from Cloud Storage**
```bash
# Upload logo to bucket
gsutil cp /path/to/logo.png gs://bucket-name/nrw-web.png

# Set in deployment
--set-env-vars="LOGO_URL=https://storage.googleapis.com/bucket-name/nrw-web.png"
```

**Option 3: Use logo from external URL**
```bash
--set-env-vars="LOGO_URL=https://example.com/nrw-web.png"
```

## Example Deployment Scenarios

### Scenario 1: Wedding Photography Site (No Age Gate)

```bash
gcloud run deploy photowebsite-weddings \
  --source . \
  --set-env-vars="SITE_NAME=Wedding Photography,PRIMARY_COLOR=#ff99cc,AGE_VERIFICATION_ENABLED=false" \
  --set-env-vars="USE_JSON=true,USE_CLOUD_STORAGE=true,GCS_BUCKET_NAME=wedding-photos-bucket" \
  --set-secrets="ADMIN_PASSWORD=photowebsite-admin-password:latest" \
  --region europe-west1
```

### Scenario 2: Portrait Studio (Blue Brand)

```bash
gcloud run deploy photowebsite-portraits \
  --source . \
  --set-env-vars="SITE_NAME=Portrait Studio,PRIMARY_COLOR=#3366ff,AGE_VERIFICATION_ENABLED=false" \
  --set-env-vars="USE_JSON=true,USE_CLOUD_STORAGE=true,GCS_BUCKET_NAME=portrait-photos-bucket" \
  --set-secrets="ADMIN_PASSWORD=photowebsite-admin-password:latest" \
  --region europe-west1
```

### Scenario 3: Boudoir Photography (Age Gate + Purple)

```bash
gcloud run deploy photowebsite-boudoir \
  --source . \
  --set-env-vars="SITE_NAME=Boudoir Photography,PRIMARY_COLOR=#9966ff,AGE_VERIFICATION_ENABLED=true" \
  --set-env-vars="USE_JSON=true,USE_CLOUD_STORAGE=true,GCS_BUCKET_NAME=boudoir-photos-bucket" \
  --set-secrets="ADMIN_PASSWORD=photowebsite-admin-password:latest" \
  --region europe-west1
```

## Files Created/Modified

### New Files
- `.gitignore` - Git ignore rules
- `DEPLOYMENT.md` - Comprehensive deployment guide
- `GITHUB_SETUP.md` - GitHub workflow guide
- `MULTI_SITE_SUMMARY.md` - This file
- `CHANGELOG.md` - Version history

### Modified Files
- `src/server.js` - Added site config from env vars
- `cloudbuild.yaml` - Added substitution variables
- `views/index.ejs` - Dynamic branding
- `README.md` - Updated with multi-site features

## Next Steps

### 1. Set Up GitHub (Recommended)

Follow the [GITHUB_SETUP.md](./GITHUB_SETUP.md) guide to:
- Create GitHub repository
- Push your code
- Set up automatic deployments
- Manage multiple site configurations

### 2. Test Configuration Changes

Try changing the color on your current site:

```bash
gcloud run services update photowebsite \
  --update-env-vars="PRIMARY_COLOR=#ff6b00" \
  --region europe-west1 \
  --project=luckypupphotography
```

Visit https://photowebsite-mrri66ie4q-ew.a.run.app and you'll see the new color!

### 3. Deploy Additional Sites

Create separate instances for different use cases (weddings, portraits, etc.)

### 4. Add Custom Domains

Map custom domains to each site:
```bash
gcloud run domain-mappings create \
  --service photowebsite \
  --domain theluckypup.uk \
  --region europe-west1
```

## Support & Documentation

- **README.md** - Overview and quick start
- **DEPLOYMENT.md** - Multi-site deployment details
- **GITHUB_SETUP.md** - GitHub workflow and automation
- **CHANGELOG.md** - Version history

## Current Status

✅ **Deployed**: v31  
✅ **Multi-Site Config**: Enabled  
✅ **Environment Variables**: Configured  
✅ **GitHub Ready**: Yes  

Your photo website platform is now ready to scale to multiple sites with different branding, all from the same codebase!

