# AI Assistant for Joomla 5

An intelligent, agentic AI system integrated into Joomla 5 that can read and modify your site content through natural language commands. Think of it as Cursor or GitHub Copilot, but specifically designed for Joomla CMS.

## 🌟 Features

- **Natural Language Interface**: Interact with your Joomla site using plain English
- **Agentic Behavior**: The AI plans, executes, and verifies actions autonomously
- **Multi-Step Reasoning**: Complex tasks are broken down and executed sequentially
- **Review Mode**: Preview all planned actions before execution
- **Comprehensive Actions**: Read and write articles, modules, menus, SP Page Builder pages, and more
- **Action Logging**: Complete audit trail of all AI actions
- **Modern UI**: Beautiful, responsive console interface
- **Two AI Providers**: Support for both OpenAI (GPT-4, GPT-5) and Anthropic (Claude 3.5, Claude Opus 4.1)

## 📋 Requirements

- Joomla 5.0 or higher
- PHP 8.2 or higher
- MySQL 5.7+ or MariaDB 10.3+
- OpenAI API key OR Anthropic API key

## 🚀 Installation

1. **Download** the plugin folder
2. **Zip** the entire `aiassistant` folder
3. **Install** via Joomla Extensions Manager
4. **Enable** the plugin in System > Plugins
5. **Configure** API keys (see Configuration section)

## ⚙️ Configuration

### 1. Choose AI Provider

Navigate to **System > Plugins > System - AI Assistant**

Select your preferred provider:
- **OpenAI** (GPT-5, GPT-5 Mini, GPT-5 Nano, GPT-4o, GPT-4o Mini, GPT-4 Turbo, GPT-4)
- **Anthropic** (Claude Opus 4.1, Claude 3.5 Sonnet, Claude 3.5 Haiku, Claude 3 Opus, Claude 3 Sonnet, Claude 3 Haiku)

### 2. Add API Key

**For OpenAI:**
1. Get your API key from https://platform.openai.com/api-keys
2. Enter it in the "OpenAI API Key" field
3. Select your preferred model

**For Anthropic:**
1. Get your API key from https://console.anthropic.com/
2. Enter it in the "Anthropic API Key" field
3. Select your preferred Claude model

### 3. Configure Permissions

Choose which actions the AI can perform:
- ✅ Read Articles
- ✅ Write/Update Articles
- ✅ Read Modules
- ✅ Write/Update Modules
- ✅ Read Menus
- ✅ Write/Update Menus
- ✅ Read SP Page Builder
- ✅ Write/Update SP Page Builder
- ✅ Read Templates
- ✅ Read Configuration

### 4. Safety Settings

- **Require Review**: Enable to review all actions before execution (recommended)
- **Max Actions Per Request**: Limit how many actions can be performed at once
- **Log All Actions**: Keep detailed logs for audit purposes

## 🎯 Accessing the Console

### Method 1: Direct URL
Navigate to:
```
https://yoursite.com/administrator/index.php?option=com_ajax&plugin=aiassistant&group=system&format=raw
```

### Method 2: Create Menu Link
Create a custom administrator menu item pointing to the above URL.

## 💡 Example Prompts

### Content Management

**Update Homepage:**
```
Change the hero section on the homepage to announce our Winter Sale 
with 20% off all products until December 31st
```

**Create Article:**
```
Create a new article titled "Our New Product Launch" in the News category. 
Include an introduction about our latest innovation and publish it immediately.
```

**Find Content:**
```
Find all unpublished articles in the Events category from the last 3 months
```

### Module Management

**Update Footer:**
```
Update the footer contact information module with our new phone number: 
+1-555-0123 and email: info@example.com
```

**List Modules:**
```
Show me all modules in the sidebar-right position that are currently published
```

### SP Page Builder

**Update Page Builder Section:**
```
On the About Us page, update the team section to include our new CEO 
Jane Smith with the title "Chief Executive Officer"
```

### Complex Multi-Step Tasks

**Complete Site Update:**
```
1. Update the homepage hero banner with our Spring Sale announcement
2. Create a new article about the sale in the Promotions category
3. Update the main menu to feature the new promotion
4. Update the footer to show the sale end date
```

## 🔍 How It Works

### The Agentic Loop

1. **Analyze**: The AI understands your natural language request
2. **Plan**: It breaks down the task into specific actions
3. **Execute**: Actions are performed sequentially (or queued for review)
4. **Verify**: Results are checked and reported back
5. **Iterate**: If needed, additional actions are taken until complete

### Available Actions

#### Read Actions
- `read_article` - Get full article data by ID
- `search_articles` - Search articles by keyword, category, or status
- `read_module` - Get module data and parameters
- `list_modules` - List modules by position or type
- `read_menu` - Get menu structure and items
- `read_pagebuilder_page` - Get SP Page Builder page content
- `get_site_info` - Get general site information

#### Write Actions
- `update_article` - Modify article content, metadata, or settings
- `create_article` - Create new articles
- `update_module` - Modify module content and parameters
- `update_pagebuilder_page` - Update SP Page Builder content
- `update_menu` - Modify menu items (planned)

## 🛡️ Security

### Permissions
- Only users with `core.admin` permission can access the console
- Fine-grained action permissions prevent unauthorized operations
- All actions are logged with user attribution

### Review Mode
Enable "Require Review" to:
- Preview all planned actions before execution
- Approve or reject individual actions
- Maintain full control over AI operations

### Audit Trail
The plugin logs:
- All user prompts
- Planned actions and their parameters
- Execution results
- Timestamps and user IDs
- Success/failure status

## 🏗️ Architecture

### Component Structure

```
plugins/system/aiassistant/
├── src/
│   ├── Extension/          # Plugin entry point
│   ├── AI/                 # AI provider interfaces
│   │   ├── OpenAIProvider.php
│   │   └── AnthropicProvider.php
│   ├── Agent/              # Orchestration logic
│   │   └── AgentOrchestrator.php
│   ├── Actions/            # Action handlers
│   │   ├── ActionRegistry.php
│   │   └── Actions/
│   │       ├── ReadArticleAction.php
│   │       ├── UpdateArticleAction.php
│   │       └── ... (more actions)
│   ├── Logger/             # Logging system
│   │   └── ActionLogger.php
│   └── Controller/         # AJAX controller
│       └── ConsoleController.php
├── tmpl/                   # Console UI template
├── media/
│   ├── css/                # Console styles
│   └── js/                 # Console JavaScript
├── language/               # Translations
└── services/               # DI provider
```

### Key Classes

**AgentOrchestrator**: The brain of the system. Implements the reasoning loop, manages conversation history, and coordinates action execution.

**ActionRegistry**: Manages available actions and their permissions. Extensible for custom actions.

**AIProvider**: Interface for AI services. Implementations for OpenAI and Anthropic included.

**ActionLogger**: Comprehensive logging system with database persistence.

## 🔧 Extending the Plugin

### Adding Custom Actions

1. Create a new action class implementing `ActionInterface`:

```php
<?php
namespace Joomla\Plugin\System\AiAssistant\Actions\Actions;

use Joomla\Plugin\System\AiAssistant\Actions\ActionInterface;

class MyCustomAction implements ActionInterface
{
    public function execute(array $parameters): array
    {
        // Your logic here
        return ['success' => true, 'data' => $result];
    }

    public static function getDescription(): string
    {
        return 'Description for the AI to understand when to use this action';
    }

    public static function getRequiredParameters(): array
    {
        return ['param1', 'param2'];
    }

    public function validate(array $parameters): bool
    {
        // Validation logic
        return true;
    }
}
```

2. Register it in `ActionRegistry::registerDefaultActions()`:

```php
$this->register('my_custom_action', Actions\MyCustomAction::class);
```

### Adding Custom AI Providers

Implement the `AIProviderInterface`:

```php
<?php
namespace Joomla\Plugin\System\AiAssistant\AI;

class CustomAIProvider implements AIProviderInterface
{
    public function chat(array $messages): string
    {
        // Call your AI service
    }

    public function getName(): string
    {
        return 'My Custom AI';
    }

    public function validateCredentials(): bool
    {
        // Validate API access
    }
}
```

## 📊 Database Tables

### `#__aiassistant_sessions`
Stores AI session information:
- Session ID
- User ID
- Original prompt
- Status and results
- Timestamps

### `#__aiassistant_actions`
Stores individual actions:
- Action type and parameters
- Execution results
- Status (planned/executed/failed)
- Associated session

Tables are created automatically on plugin installation.

## 🐛 Troubleshooting

### Console Not Loading
- Check that the plugin is enabled
- Verify you have `core.admin` permissions
- Check browser console for JavaScript errors

### AI Not Responding
- Verify your API key is correct
- Check API quota/billing status
- Review PHP error logs for connectivity issues

### Actions Not Executing
- Check action permissions in plugin settings
- Verify the action is registered in ActionRegistry
- Review the session log for error details

### Database Errors
- Ensure tables were created (check database)
- Verify database user has CREATE TABLE permissions
- Check Joomla error logs

## 📝 Changelog

### Version 1.0.0 (October 2025)
- Initial release
- Support for OpenAI and Anthropic
- 10+ built-in actions
- Review mode
- Comprehensive logging
- Modern console UI
- Multi-step reasoning

## 🤝 Contributing

This plugin is designed to be extensible. Contributions welcome for:
- Additional action handlers
- UI improvements
- Additional AI providers
- Bug fixes
- Documentation improvements

## 📄 License

GNU General Public License version 2 or later
Copyright (C) 2025 Open Source Matters. All rights reserved.

## 🙏 Credits

Inspired by:
- Cursor IDE's agentic capabilities
- GitHub Copilot's AI assistance
- The Joomla community

## 📧 Support

For issues, questions, or feature requests, please open an issue in the repository.

---

**Warning**: This plugin gives AI significant control over your Joomla site. Always:
- Use review mode in production
- Keep backups
- Test thoroughly in development first
- Monitor the action logs
- Start with limited permissions

**Note**: AI responses can be unpredictable. While the plugin includes safety measures, always review actions before execution on production sites.

