<?php
/**
 * Debug script to test AI Assistant
 * DELETE THIS FILE AFTER USE
 */

define('_JEXEC', 1);
define('JPATH_BASE', __DIR__);

require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';

use Joomla\CMS\Factory;
use Joomla\CMS\Log\Log;

// Set up logging
Log::addLogger(
    ['text_file' => 'aiassistant_debug.php'],
    Log::ALL,
    ['aiassistant']
);

$app = Factory::getApplication('administrator');
$user = $app->getIdentity();

if (!$user || !$user->authorise('core.admin')) {
    die('<h1>Unauthorized</h1><p>You must be logged in as a Super User.</p>');
}

echo '<h1>AI Assistant Debug</h1>';
echo '<style>pre { background: #f5f5f5; padding: 10px; border: 1px solid #ddd; } .error { color: red; } .success { color: green; }</style>';

// Test 1: Check if plugin is installed and enabled
echo '<h2>Test 1: Plugin Status</h2>';
$plugin = \Joomla\CMS\Plugin\PluginHelper::getPlugin('system', 'aiassistant');
if ($plugin) {
    echo '<p class="success">✓ Plugin found</p>';
    echo '<pre>';
    print_r($plugin);
    echo '</pre>';
} else {
    echo '<p class="error">✗ Plugin not found or not enabled</p>';
    die();
}

// Test 2: Check database connection
echo '<h2>Test 2: Database Connection</h2>';
try {
    $db = Factory::getDbo();
    if ($db) {
        echo '<p class="success">✓ Database connected</p>';
    } else {
        echo '<p class="error">✗ Database is null</p>';
    }
} catch (\Exception $e) {
    echo '<p class="error">✗ Database error: ' . $e->getMessage() . '</p>';
}

// Test 3: Check if Factory::getContainer() works
echo '<h2>Test 3: DI Container</h2>';
try {
    $container = Factory::getContainer();
    if ($container) {
        echo '<p class="success">✓ Container available</p>';
    } else {
        echo '<p class="error">✗ Container is null</p>';
    }
} catch (\Exception $e) {
    echo '<p class="error">✗ Container error: ' . $e->getMessage() . '</p>';
}

// Test 4: Try to load the plugin class
echo '<h2>Test 4: Load Plugin Class</h2>';
try {
    if (class_exists('Joomla\\Plugin\\System\\AiAssistant\\Extension\\AiAssistant')) {
        echo '<p class="success">✓ Plugin class exists</p>';
        
        // Try to instantiate
        $dispatcher = $app->getDispatcher();
        $pluginClass = new \Joomla\Plugin\System\AiAssistant\Extension\AiAssistant(
            $dispatcher,
            (array) $plugin
        );
        $pluginClass->setApplication($app);
        $pluginClass->setDatabase($db);
        
        echo '<p class="success">✓ Plugin instantiated successfully</p>';
    } else {
        echo '<p class="error">✗ Plugin class not found</p>';
    }
} catch (\Exception $e) {
    echo '<p class="error">✗ Error instantiating plugin: ' . $e->getMessage() . '</p>';
    echo '<pre>' . $e->getTraceAsString() . '</pre>';
}

// Test 5: Check Joomla logs
echo '<h2>Test 5: Recent AI Assistant Logs (Last 100 lines)</h2>';
$logFile = JPATH_ADMINISTRATOR . '/logs/aiassistant.php';
if (file_exists($logFile)) {
    echo '<div style="background:#000; color:#0f0; padding:10px; overflow:auto; max-height:400px; font-family:monospace; font-size:12px;">';
    $lines = file($logFile);
    $recentLines = array_slice($lines, -100); // Last 100 lines
    foreach ($recentLines as $line) {
        if (strpos($line, '[ERROR]') !== false || strpos($line, '[FATAL]') !== false) {
            echo '<span style="color:#f00; font-weight:bold;">' . htmlspecialchars($line) . '</span>';
        } elseif (strpos($line, '[DEBUG]') !== false) {
            echo '<span style="color:#0ff;">' . htmlspecialchars($line) . '</span>';
        } elseif (strpos($line, '[WARN]') !== false) {
            echo '<span style="color:#ff0;">' . htmlspecialchars($line) . '</span>';
        } else {
            echo htmlspecialchars($line) . '<br>';
        }
    }
    echo '</div>';
    echo '<p><strong>Look for [FATAL] or [ERROR] lines above - they will show the exact file and line number!</strong></p>';
} else {
    echo '<p>No log file found at: ' . htmlspecialchars($logFile) . '</p>';
}

echo '<h2>Test 6: Check PHP Error Log</h2>';
$errorLog = ini_get('error_log');
echo '<p>Error log location: ' . htmlspecialchars($errorLog) . '</p>';
echo '<p>Check your PHP error log for the exact file and line number of the error.</p>';

echo '<hr><p><strong>Done!</strong> If all tests pass but you still get the error, check the PHP error log for the exact location.</p>';
echo '<p><em>Remember to delete this file after use!</em></p>';

