#!/bin/bash
# Local Development Setup Script

set -e  # Exit on error

echo "NRW Web - Local Development Setup"
echo "================================================"
echo ""

# Check if Node.js is installed
if ! command -v node &> /dev/null; then
    echo "Error: Node.js is not installed"
    echo "Please install Node.js from: https://nodejs.org/"
    exit 1
fi

echo "✓ Node.js $(node --version) found"

# Check if npm is installed
if ! command -v npm &> /dev/null; then
    echo "Error: npm is not installed"
    exit 1
fi

echo "✓ npm $(npm --version) found"
echo ""

# Install dependencies
echo "Installing dependencies..."
npm install
echo "✓ Dependencies installed"
echo ""

# Create .env file if it doesn't exist
if [ ! -f .env ]; then
    echo "Creating .env file..."
    cat > .env << EOF
# Local Development Environment Variables

# Database Configuration (SQLite)
USE_POSTGRES=false

# Storage Configuration (Local Filesystem)
USE_CLOUD_STORAGE=false

# Application Configuration
PORT=3000
ADMIN_PASSWORD=changeme

# Node Environment
NODE_ENV=development
EOF
    echo "✓ .env file created"
    echo ""
    echo "IMPORTANT: Change ADMIN_PASSWORD in .env file!"
    echo ""
else
    echo "✓ .env file already exists"
    echo ""
fi

# Build CSS
echo "Building CSS from SCSS..."
npm run build:css
echo "✓ CSS built"
echo ""

# Create necessary directories
mkdir -p data
mkdir -p uploads
echo "✓ Directories created"
echo ""

echo "Setup complete!"
echo ""
echo "To start the development server:"
echo "  npm run dev"
echo ""
echo "Or to start in production mode:"
echo "  npm start"
echo ""
echo "Then visit:"
echo "  Public: http://localhost:3000"
echo "  Admin:  http://localhost:3000/admin"
echo ""

