(function(){
  function ready(fn){ if(document.readyState!=='loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }

  ready(function(){
    const galleryLinks = Array.from(document.querySelectorAll('.gallery a'));
    if (galleryLinks.length === 0) return;

    // Calculate row spans for grid masonry
    galleryLinks.forEach(function(link) {
      const img = link.querySelector('img');
      if (img) {
        img.onload = function() {
          const rowSpan = Math.ceil(this.naturalHeight / (this.naturalWidth / 200) / 10);
          link.style.setProperty('--row-span', rowSpan);
        };
        if (img.complete) img.onload();
      }
    });

    const imageUrls = galleryLinks.map(a => a.getAttribute('href'));
    let currentIndex = 0;

    // Build overlay once
    const overlay = document.createElement('div');
    overlay.className = 'lightbox';
    overlay.innerHTML = `
      <button class="lightbox__close" aria-label="Close">×</button>
      <button class="lightbox__prev" aria-label="Previous">‹</button>
      <img class="lightbox__img" alt="" />
      <button class="lightbox__next" aria-label="Next">›</button>
    `;
    document.body.appendChild(overlay);

    const img = overlay.querySelector('.lightbox__img');
    const btnClose = overlay.querySelector('.lightbox__close');
    const btnPrev = overlay.querySelector('.lightbox__prev');
    const btnNext = overlay.querySelector('.lightbox__next');

    function updateNavVisibility(){
      if (imageUrls.length <= 1) {
        btnPrev.style.display = 'none';
        btnNext.style.display = 'none';
      } else {
        btnPrev.style.display = '';
                       btnNext.style.display = '';
      }
    }

    function openAt(index){
      currentIndex = Math.max(0, Math.min(index, imageUrls.length - 1));
      img.src = imageUrls[currentIndex];
      overlay.classList.add('lightbox--open');
      updateNavVisibility();
      document.addEventListener('keydown', onKey);
    }

    function close(){
      overlay.classList.remove('lightbox--open');
      document.removeEventListener('keydown', onKey);
    }

    function prev(){ openAt((currentIndex - 1 + imageUrls.length) % imageUrls.length); }
    function next(){ openAt((currentIndex + 1) % imageUrls.length); }

    function onKey(e){
      if (e.key === 'Escape') close();
      else if (e.key === 'ArrowLeft') prev();
      else if (e.key === 'ArrowRight') next();
    }

    overlay.addEventListener('click', function(e){
      // close when clicking outside the image and buttons
      const target = e.target;
      if (target === overlay) close();
    });
    btnClose.addEventListener('click', close);
    btnPrev.addEventListener('click', prev);
    btnNext.addEventListener('click', next);

    galleryLinks.forEach(function(a, idx){
      a.addEventListener('click', function(ev){
        ev.preventDefault();
        openAt(idx);
      });
    });
  });
})();


